/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent;

import java.util.Iterator;
import jeus.util.concurrent.CopyOnWriteArraySet;
import jeus.util.concurrent.Sync;

public class ObservableSync
implements Sync {
    protected final CopyOnWriteArraySet observers_ = new CopyOnWriteArraySet();
    protected Object arg_;

    public ObservableSync(Object notificationArgument) {
        this.arg_ = notificationArgument;
    }

    public synchronized Object getNotificationArgument() {
        return this.arg_;
    }

    public synchronized Object setNotificationArgument(Object notificationArg) {
        Object old = this.arg_;
        this.arg_ = notificationArg;
        return old;
    }

    public void acquire() {
        Object arg = this.getNotificationArgument();
        Iterator it = this.observers_.iterator();
        while (it.hasNext()) {
            ((SyncObserver)it.next()).onAcquire(arg);
        }
    }

    public boolean attempt(long msecs) {
        this.acquire();
        return true;
    }

    public void release() {
        Object arg = this.getNotificationArgument();
        Iterator it = this.observers_.iterator();
        while (it.hasNext()) {
            ((SyncObserver)it.next()).onRelease(arg);
        }
    }

    public void attach(SyncObserver obs) {
        this.observers_.add(obs);
    }

    public void detach(SyncObserver obs) {
        this.observers_.remove(obs);
    }

    public Iterator observers() {
        return this.observers_.iterator();
    }

    public static interface SyncObserver {
        public void onAcquire(Object var1);

        public void onRelease(Object var1);
    }
}

