/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent;

import jeus.util.concurrent.FIFOSemaphore;
import jeus.util.concurrent.QueuedSemaphore;

public class PrioritySemaphore
extends QueuedSemaphore {
    public PrioritySemaphore(long initialPermits) {
        super(new PriorityWaitQueue(), initialPermits);
    }

    protected static class PriorityWaitQueue
    extends QueuedSemaphore.WaitQueue {
        protected final FIFOSemaphore.FIFOWaitQueue[] cells_ = new FIFOSemaphore.FIFOWaitQueue[10];
        protected int maxIndex_ = -1;

        protected PriorityWaitQueue() {
            for (int i = 0; i < this.cells_.length; ++i) {
                this.cells_[i] = new FIFOSemaphore.FIFOWaitQueue();
            }
        }

        protected void insert(QueuedSemaphore.WaitQueue.WaitNode w) {
            int idx = Thread.currentThread().getPriority() - 1;
            this.cells_[idx].insert(w);
            if (idx > this.maxIndex_) {
                this.maxIndex_ = idx;
            }
        }

        protected QueuedSemaphore.WaitQueue.WaitNode extract() {
            int idx;
            while ((idx = this.maxIndex_--) >= 0) {
                QueuedSemaphore.WaitQueue.WaitNode w = this.cells_[idx].extract();
                if (w == null) continue;
                return w;
            }
            return null;
        }
    }
}

