/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent;

import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import jeus.util.concurrent.ReadWriteLock;
import jeus.util.concurrent.Sync;
import jeus.util.concurrent.SyncSet;

public class SyncSortedSet
extends SyncSet
implements SortedSet {
    public SyncSortedSet(SortedSet set, Sync sync) {
        super((Set)set, sync);
    }

    public SyncSortedSet(SortedSet set, ReadWriteLock rwl) {
        super(set, rwl.readLock(), rwl.writeLock());
    }

    public SyncSortedSet(SortedSet set, Sync readLock, Sync writeLock) {
        super(set, readLock, writeLock);
    }

    protected SortedSet baseSortedSet() {
        return (SortedSet)this.c_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comparator comparator() {
        boolean wasInterrupted = this.beforeRead();
        try {
            Comparator comparator = this.baseSortedSet().comparator();
            return comparator;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object first() {
        boolean wasInterrupted = this.beforeRead();
        try {
            Object e = this.baseSortedSet().first();
            return e;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object last() {
        boolean wasInterrupted = this.beforeRead();
        try {
            Object e = this.baseSortedSet().last();
            return e;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet subSet(Object fromElement, Object toElement) {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncSortedSet syncSortedSet = new SyncSortedSet(this.baseSortedSet().subSet(fromElement, toElement), this.rd_, this.wr_);
            return syncSortedSet;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet headSet(Object toElement) {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncSortedSet syncSortedSet = new SyncSortedSet(this.baseSortedSet().headSet(toElement), this.rd_, this.wr_);
            return syncSortedSet;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet tailSet(Object fromElement) {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncSortedSet syncSortedSet = new SyncSortedSet(this.baseSortedSet().tailSet(fromElement), this.rd_, this.wr_);
            return syncSortedSet;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }
}

