/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.ErrorManager;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import jeus.util.file.FileUtils;
import jeus.util.logging.StreamHandler;

public class FileHandler
extends StreamHandler {
    private static final String DEFAULT_FORMAT = "yyyyMMdd";
    private static final int DEFAULT_BUFFER = 1024;
    private String dateFormat = "yyyyMMdd";
    private boolean append;
    private String pattern;
    private int bufferSize;
    private long nextChangeTime = Long.MAX_VALUE;
    private String name = this.getClass().getName() + "@" + this.hashCode();
    private File file;
    private int validHour;
    private int validDay;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getValidHour() {
        return this.validHour;
    }

    public int getValidDay() {
        return this.validDay;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getFileName() {
        return this.file != null ? this.file.getAbsolutePath() : null;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public String getFilePattern() {
        return this.pattern;
    }

    private void openFile() throws IOException {
        LogManager manager = LogManager.getLogManager();
        manager.checkAccess();
        InitializationErrorManager em = new InitializationErrorManager();
        this.setErrorManager(em);
        this.open();
        Exception ex = em.lastException;
        if (ex != null) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof SecurityException) {
                throw (SecurityException)ex;
            }
            throw new IOException("Exception: " + ex);
        }
        this.setErrorManager(new ErrorManager());
    }

    protected void open() throws FileNotFoundException {
        Calendar currentCal = Calendar.getInstance();
        long time = currentCal.getTime().getTime();
        this.file = this.getPatternedTime(this.pattern, currentCal);
        if (!this.file.exists()) {
            FileUtils.makeDirectories(this.file);
        }
        FileOutputStream fout = new FileOutputStream(this.file.getAbsolutePath(), this.append);
        this.setOutputStream(fout, this.bufferSize < 0 ? 0 : this.bufferSize);
        long changedTime = currentCal.getTime().getTime();
        if (time != changedTime) {
            this.nextChangeTime = changedTime;
        }
    }

    public File getPatternedTime(String pattern, Calendar currentCal) {
        File file = null;
        int previousCreateHourFraction = -1;
        String word = "";
        int ix = 0;
        boolean isCalendarUsed = false;
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
            }
            if (ch == '/') {
                file = file == null ? new File(word) : new File(file, word);
                word = "";
                continue;
            }
            if (ch == '%') {
                if (ch2 == 'd') {
                    if (isCalendarUsed) {
                        throw new IllegalArgumentException("The %d should be at most one");
                    }
                    String parameter = FileHandler.getParamter(ix, pattern, ch2);
                    this.validDay = Integer.parseInt(parameter);
                    isCalendarUsed = true;
                    word = word + new SimpleDateFormat(this.dateFormat).format(currentCal.getTime());
                    ix += parameter.length() + 3;
                    continue;
                }
                if (ch2 == 'h') {
                    if (previousCreateHourFraction >= 0) {
                        throw new IllegalArgumentException("The %h should be at most one");
                    }
                    String paramter = FileHandler.getParamter(ix, pattern, ch2);
                    this.validHour = Integer.parseInt(paramter);
                    int hour = this.validHour % 24;
                    if (24 % hour > 0) {
                        throw new IllegalArgumentException("The parameter of %h should be one of divisors for 24");
                    }
                    previousCreateHourFraction = FileHandler.getCurrentTimeFraction(hour);
                    word = word + previousCreateHourFraction;
                    ix += paramter.length() + 3;
                    continue;
                }
                if (ch2 == '%') {
                    word = word + "%";
                    ++ix;
                    continue;
                }
            }
            word = word + ch;
        }
        if (!isCalendarUsed && previousCreateHourFraction >= 0) {
            throw new IllegalArgumentException("The %h needs %d option");
        }
        if (isCalendarUsed) {
            if (previousCreateHourFraction >= 0) {
                currentCal.set(currentCal.get(1), currentCal.get(2), currentCal.get(5), previousCreateHourFraction + this.validHour, 0, 0);
            } else {
                currentCal.set(currentCal.get(1), currentCal.get(2), currentCal.get(5) + this.validDay, 0, 0, 0);
            }
            currentCal.set(14, 0);
        }
        if (word.length() > 0) {
            file = file == null ? new File(word) : new File(file, word);
        }
        return file;
    }

    private static int getCurrentTimeFraction(int hour) {
        Calendar cal = Calendar.getInstance();
        return cal.get(11) / hour * hour;
    }

    private static String getParamter(int ix, String pattern, char option) {
        if (++ix >= pattern.length()) {
            throw new IllegalArgumentException("'{' should follow %" + option);
        }
        char ch2 = Character.toLowerCase(pattern.charAt(ix));
        if (ch2 != '{') {
            throw new IllegalArgumentException("'{' should follow %" + option);
        }
        StringBuffer simpleDataFormat = new StringBuffer();
        if (++ix < pattern.length()) {
            ch2 = Character.toLowerCase(pattern.charAt(ix));
        } else {
            throw new IllegalArgumentException("%" + option + "{} is not completed");
        }
        while (ch2 != '}') {
            simpleDataFormat.append(ch2);
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
                continue;
            }
            throw new IllegalArgumentException("%" + option + "{} is not completed");
        }
        return simpleDataFormat.toString();
    }

    public void setProperty(Map propertyMap) throws IOException {
        this.pattern = (String)propertyMap.get("pattern");
        Object value = propertyMap.get("bufferSize");
        this.bufferSize = value == null ? 1024 : (value instanceof Integer ? (Integer)value : Integer.parseInt((String)value));
        value = propertyMap.get("validDay");
        this.validDay = value == null ? 0 : (value instanceof Integer ? (Integer)value : Integer.parseInt((String)value));
        value = propertyMap.get("validHour");
        this.validHour = value == null ? 0 : (value instanceof Integer ? (Integer)value : Integer.parseInt((String)value));
        value = propertyMap.get("append");
        this.append = value instanceof Boolean ? (Boolean)value : Boolean.valueOf((String)value);
        this.openFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoggable(LogRecord record) {
        long millis = record.getMillis();
        if (super.isLoggable(record)) {
            if (millis > this.nextChangeTime) {
                FileHandler fileHandler = this;
                synchronized (fileHandler) {
                    if (millis > this.nextChangeTime) {
                        try {
                            this.open();
                        }
                        catch (FileNotFoundException ex) {
                            this.getErrorManager().error("Exception occurred during changing log file", ex, 4);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private class InitializationErrorManager
    extends ErrorManager {
        private Exception lastException;

        private InitializationErrorManager() {
        }

        public void error(String msg, Exception ex, int code) {
            this.lastException = ex;
        }
    }
}

