/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.util.logging.Level;

public class JeusLevel {
    public static final Level FATAL = Level.SEVERE;
    public static final Level NOTICE = Level.WARNING;
    public static final Level DEBUG = Level.FINE;
    public static final Level INFORMATION = Level.INFO;
    public static final Level DEV = new DevLevel("DEV", -2147483647);

    public static Level parse(String level) {
        if (level == null) {
            throw new IllegalArgumentException();
        }
        if (level.equalsIgnoreCase("FATAL")) {
            return FATAL;
        }
        if (level.equalsIgnoreCase("NOTICE")) {
            return NOTICE;
        }
        if (level.equalsIgnoreCase("DEBUG")) {
            return DEBUG;
        }
        if (level.equalsIgnoreCase("INFORMATION")) {
            return INFORMATION;
        }
        if (level.equalsIgnoreCase("DEV")) {
            return DEV;
        }
        return Level.parse(level.toUpperCase());
    }

    public static Level getTempLevel(int level) {
        return new DevLevel("temp", level);
    }

    private static class DevLevel
    extends Level {
        public DevLevel(String name, int value) {
            super(name, value);
        }
    }
}

