/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.util.Map;
import java.util.Properties;
import java.util.logging.LogRecord;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jeus.util.logging.ErrorLogRecord;
import jeus.util.logging.JeusHandler;

public class SmtpHandler
extends JeusHandler {
    public static final String SMTP_HOST_PROPERTY_KEY = "mail.smtp.host";
    public static final String FROM_ADDRESS_PROPERTY_KEY = "mail.from.address";
    public static final String TO_ADDRESS_PROPERTY_KEY = "mail.to.recipients";
    public static final String CC_ADDRESS_PROPERTY_KEY = "mail.to.ccrecipients";
    public static final String BCC_ADDRESS_PROPERTY_KEY = "mail.to.bccrecipients";
    private Session session;
    private MimeMessage message;
    private String name = this.getClass().getName() + "@" + this.hashCode();

    public void setProperty(Map propertyMap) {
        try {
            String host = (String)propertyMap.get(SMTP_HOST_PROPERTY_KEY);
            Properties prop = System.getProperties();
            prop.put(SMTP_HOST_PROPERTY_KEY, host);
            this.session = Session.getInstance((Properties)prop, null);
            this.message = new MimeMessage(this.session);
            String from = (String)propertyMap.get(FROM_ADDRESS_PROPERTY_KEY);
            InternetAddress fromAddr = new InternetAddress(from);
            this.message.setFrom((Address)fromAddr);
            String tos = (String)propertyMap.get(TO_ADDRESS_PROPERTY_KEY);
            String ccs = (String)propertyMap.get(CC_ADDRESS_PROPERTY_KEY);
            String bccs = (String)propertyMap.get(BCC_ADDRESS_PROPERTY_KEY);
            if (tos != null) {
                InternetAddress[] toAddr = InternetAddress.parse((String)tos);
                this.message.setRecipients(Message.RecipientType.TO, (Address[])toAddr);
            }
            if (ccs != null) {
                InternetAddress[] ccAddr = InternetAddress.parse((String)ccs);
                this.message.setRecipients(Message.RecipientType.CC, (Address[])ccAddr);
            }
            if (bccs != null) {
                InternetAddress[] bccAddr = InternetAddress.parse((String)bccs);
                this.message.setRecipients(Message.RecipientType.BCC, (Address[])bccAddr);
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public void publish(LogRecord record) {
        if (this.message == null) {
            return;
        }
        try {
            String subject;
            String msg = this.getFormatter().format(record);
            if (record instanceof ErrorLogRecord) {
                ErrorLogRecord errRecord = (ErrorLogRecord)record;
                subject = errRecord.getSubject();
                if (subject == null) {
                    subject = record.getLoggerName() + " : " + msg.substring(0, msg.indexOf(10));
                }
            } else {
                subject = record.getLoggerName() + " : " + msg.substring(0, msg.indexOf(10));
            }
            this.message.setSubject(subject);
            this.message.setText(msg);
            Transport.send((Message)this.message);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void flush() {
    }

    public synchronized void close() throws SecurityException {
    }
}

