/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Vector;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.message.JeusMessage_Network;
import jeus.util.net.AbstractActiveDispatcher;
import jeus.util.net.DispatcherRequestHandler;
import jeus.util.net.JNBBuffer;
import jeus.util.net.SocketDispatcherListener;
import jeus.util.properties.JeusNetProperties;

class ActiveDispatcher
extends AbstractActiveDispatcher {
    private Vector regList;
    private ServerSocketChannel serverSocketChannel;
    private Selector selector;

    ActiveDispatcher(Executor executor, int listenport, int backlog, boolean enableSSL, int sslPort, SocketDispatcherListener listener) throws IOException {
        super(executor, listenport, backlog, enableSSL, sslPort, listener);
    }

    protected void initSocket() throws IOException {
        this.regList = new Vector();
        this.selector = Selector.open();
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.configureBlocking(false);
        ServerSocket cServerSocket = this.serverSocketChannel.socket();
        if (JeusNetProperties.REUSE_ADDRESS != null) {
            cServerSocket.setReuseAddress(Boolean.valueOf(JeusNetProperties.REUSE_ADDRESS));
        }
        InetSocketAddress localAddr = new InetSocketAddress(this.listenport);
        try {
            cServerSocket.bind(localAddr, this.backlog);
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_Network._1030_LEVEL)) {
                logger.log(JeusMessage_Network._1030_LEVEL, JeusMessage_Network._1030, localAddr, (Throwable)ex);
            }
            throw ex;
        }
        this.serverSocketChannel.register(this.selector, 16);
        if (logger.isLoggable(JeusMessage_Network._1003_LEVEL)) {
            logger.log(JeusMessage_Network._1003_LEVEL, JeusMessage_Network._1003, (Object)Integer.toString(this.listenport));
        }
    }

    protected void destroyInternal() {
        try {
            this.selector.wakeup();
            this.serverSocketChannel.close();
            this.selector.close();
            JNBBuffer[] buffers = JNBBuffer.bufferList.toArray(new JNBBuffer[0]);
            for (int i = 0; i < buffers.length; ++i) {
                JNBBuffer buffer = buffers[i];
                buffer.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        while (this.running) {
            try {
                this.selector.select();
                if (!this.running) break;
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                this.process(it);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.listener.failover(ioe, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Iterator it) throws IOException {
        SocketChannel sc;
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            if (key == null) continue;
            if (key.isAcceptable()) {
                ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
                sc = ssc.accept();
                sc.configureBlocking(false);
                JNBBuffer buf = new JNBBuffer(sc, this);
                sc.register(this.selector, 1, buf);
            } else if (key.isReadable()) {
                JNBBuffer buf = (JNBBuffer)key.attachment();
                boolean ready = false;
                try {
                    ready = buf.readData();
                }
                catch (IOException ioe) {
                    if (buf.getId().size() > 0 && logger.isLoggable(JeusMessage_Network._1004_LEVEL)) {
                        logger.log(JeusMessage_Network._1004_LEVEL, JeusMessage_Network._1004, buf.getSocketChannel(), (Throwable)ioe);
                    }
                    buf.destroy();
                }
                if (ready) {
                    SocketChannel sc2 = buf.getSocketChannel();
                    try {
                        this.handleRequest(buf);
                    }
                    catch (IOException ioe) {
                        buf.destroy();
                        sc2.close();
                    }
                    buf.reset();
                }
            }
            it.remove();
        }
        this.selector.selectNow();
        Vector vector = this.regList;
        synchronized (vector) {
            while (this.regList.size() != 0) {
                JNBBuffer b = (JNBBuffer)this.regList.remove(0);
                sc = b.getSocketChannel();
                sc.configureBlocking(false);
                sc.register(this.selector, 1, b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(JNBBuffer buf) throws IOException {
        int opcode = buf.getOpcode();
        try {
            DispatcherRequestHandler handler = this.handlerFactory.getHandler(opcode);
            if (handler == null) {
                if (logger.isLoggable(JeusMessage_Network._1002_LEVEL)) {
                    logger.log(JeusMessage_Network._1002_LEVEL, JeusMessage_Network._1002, (Object)Integer.toHexString(opcode));
                }
                return;
            }
            SocketChannel sc = buf.getSocketChannel();
            sc.keyFor(this.selector).cancel();
            sc.configureBlocking(true);
            handler.handleRequest(buf);
        }
        finally {
            if (opcode != 100) {
                this.regList.add(buf);
            }
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public String getDispatcherName() {
        return "<ActiveDispatcher>";
    }

    void removeListenerById(Object[] id, JNBBuffer buffer) {
        this.receiverTable.unregister(id, buffer);
    }

    public int getPort() {
        return this.serverSocketChannel.socket().getLocalPort();
    }

    public String getHostAddress() {
        return this.serverSocketChannel.socket().getInetAddress().getHostAddress();
    }
}

