/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.net.Dispatcher;
import jeus.util.net.DispatcherRequestHandler;
import jeus.util.net.JNBBuffer;
import jeus.util.net.ReceiverTable;
import jeus.util.net.SocketDispatcher;
import jeus.util.net.VirtualListener;

class ConRequestHandler
extends DispatcherRequestHandler {
    private JeusLogger logger = SocketDispatcher.logger;
    private Executor executor;
    private ReceiverTable receiverTable;

    ConRequestHandler(Executor executor, ReceiverTable recvTable, String dispatcherName) {
        this.executor = executor;
        this.receiverTable = recvTable;
        this.dispatcherName = dispatcherName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRequest(JNBBuffer buf) throws IOException {
        String id = buf.getBodyString();
        VirtualListener r = (VirtualListener)this.receiverTable.get(id);
        SocketChannel soc = buf.getSocketChannel();
        if (r == null) {
            if (this.logger.isLoggable(JeusMessage_Network._1009_LEVEL)) {
                this.logger.log(JeusMessage_Network._1009_LEVEL, JeusMessage_Network._1009, new Object[]{this.dispatcherName, id});
            }
            try {
                soc.write(ByteBuffer.wrap(SOCKPASS_DEST_NOT_FOUND_BYTES));
            }
            finally {
                buf.destroy();
            }
        }
        buf.setSocketChannel(null);
        try {
            if (this.logger.isLoggable(JeusMessage_Network._1010_LEVEL)) {
                this.logger.log(JeusMessage_Network._1010_LEVEL, JeusMessage_Network._1010, new Object[]{this.dispatcherName, soc, r.getId()});
            }
            Dispatcher dispatcher = new Dispatcher(r, soc);
            if (this.executor == null) {
                dispatcher.run();
            } else {
                this.executor.execute(dispatcher);
            }
        }
        finally {
            buf.destroy();
        }
    }
}

