/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.util.ByteUtil;
import jeus.util.cnet.SockPassConstants;
import jeus.util.net.AbstractActiveDispatcher;
import jeus.util.net.JeusTransceiver;
import jeus.util.net.PipeSocket;

public final class JNBBuffer {
    private SocketChannel sc;
    private ByteBuffer header = ByteBufferCreator.allocateByteBuffer(true, 12, true);
    private ByteBuffer body = null;
    private byte[] hdrbuf = new byte[12];
    private byte[] bodybuf;
    private int opcode;
    private JeusTransceiver strans;
    private boolean destroyed;
    private Vector id;
    private static final int READ_HEADER = 0;
    private static final int READ_BODY = 1;
    private int status = 0;
    private PipeSocket psock;
    static Set bufferList = Collections.synchronizedSet(new HashSet());
    private final Object sendingSync = new Object();
    private final AbstractActiveDispatcher dispatcher;

    JNBBuffer(SocketChannel ch, AbstractActiveDispatcher dispatcher) {
        this.sc = ch;
        this.destroyed = false;
        this.id = new Vector();
        this.dispatcher = dispatcher;
        this.reset();
        bufferList.add(this);
    }

    synchronized void setTransceiver(boolean pipeSupported) throws IOException {
        if (this.strans == null) {
            int pid;
            String pids = this.getBodyString();
            try {
                pid = Integer.parseInt(pids);
            }
            catch (Exception e) {
                throw new IOException("invalid pid : " + pids);
            }
            if (pipeSupported) {
                this.psock = new PipeSocket("JPIPE_" + pids, true, true);
                this.strans = new JeusTransceiver(this.psock, pid);
            } else {
                this.strans = new JeusTransceiver(this.sc, pid);
            }
            ByteBuffer b = ByteBuffer.wrap(SockPassConstants.OP_SOCKTRANS_REG_OK_BYTES);
            this.sc.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendSocketChannel(SocketChannel channel, int dstport) throws IOException {
        Object object = this.sendingSync;
        synchronized (object) {
            if (this.strans == null) {
                throw new IOException("strans is null");
            }
            this.strans.sendChannel(channel, dstport);
        }
    }

    void addId(String i) {
        if (this.id.indexOf(i) == -1) {
            this.id.add(i);
        }
    }

    public Vector getId() {
        return this.id;
    }

    public void removeId(String i) {
        this.id.removeElement(i);
    }

    private void checkMagic(byte[] buf) throws IOException {
        for (int i = 0; i < SockPassConstants.MAGIC.length; ++i) {
            if (SockPassConstants.MAGIC[i] == buf[i]) continue;
            throw new IOException("<SocketDispatcher> magic mismatch : " + new String(buf, 0, 7));
        }
    }

    private int getBodyLength(byte[] buf) {
        return ByteUtil.convertToInt(buf, 8);
    }

    boolean readData() throws IOException {
        this.sc.socket().setSoTimeout(30000);
        switch (this.status) {
            case 0: {
                int n = this.sc.read(this.header);
                if (n < 0) {
                    throw new EOFException("<JNBBuffer> EOF received while reading header.");
                }
                if (this.header.hasRemaining()) {
                    return false;
                }
                this.header.flip();
                this.header.get(this.hdrbuf);
                this.header.rewind();
                this.checkMagic(this.hdrbuf);
                this.opcode = this.hdrbuf[7];
                int bodylen = this.getBodyLength(this.hdrbuf);
                this.body = ByteBufferCreator.allocateByteBuffer(true, bodylen, true);
                this.bodybuf = new byte[bodylen];
                this.status = 1;
            }
            case 1: {
                int n = this.sc.read(this.body);
                if (n < 0) {
                    throw new EOFException("<JNBBuffer> EOF received while reading header.");
                }
                if (this.body.hasRemaining()) {
                    return false;
                }
                this.body.flip();
                this.body.get(this.bodybuf);
                ByteBufferCreator.freeByteBuffer(this.body);
                this.body = null;
                this.status = 0;
                this.sc.socket().setSoTimeout(0);
                return true;
            }
        }
        throw new RuntimeException();
    }

    void reset() {
        this.opcode = 0;
        if (this.header != null) {
            this.header.rewind();
        }
        this.body = null;
        this.bodybuf = null;
    }

    int getOpcode() {
        return this.opcode;
    }

    String getBodyString() {
        if (this.bodybuf == null) {
            return null;
        }
        return new String(this.bodybuf);
    }

    void destroy() {
        if (!this.destroyed) {
            bufferList.remove(this);
            this.destroyed = true;
            ByteBufferCreator.freeByteBuffer(this.header);
            this.header = null;
            if (this.sc != null) {
                Socket socket = this.sc.socket();
                try {
                    socket.shutdownInput();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                try {
                    socket.shutdownOutput();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.psock != null) {
                try {
                    this.psock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.id.size() > 0) {
                this.dispatcher.removeListenerById(this.id.toArray(), this);
                this.id.clear();
            }
        }
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.sc = socketChannel;
    }

    public SocketChannel getSocketChannel() {
        return this.sc;
    }
}

