/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.DataInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import jeus.util.CUtility;
import jeus.util.net.SocketTransceiver;
import jeus.util.net.TestConstant;

public class TestListener
extends Thread
implements TestConstant {
    private int port;
    private boolean running;
    private Hashtable handlerList;
    private int mypid = CUtility.thisProcessPID;

    public TestListener(int lport) {
        this.port = lport;
        this.running = true;
        this.handlerList = new Hashtable();
    }

    private void handle(Socket socket) {
        try {
            DataInputStream in = new DataInputStream(socket.getInputStream());
            int magic = in.readInt();
            if (magic != 66595) {
                throw new Exception("magic error : " + Integer.toHexString(magic));
            }
            int opcode = in.readInt();
            int peer_pid = in.readInt();
            int totalLength = in.readInt();
            int fcount = in.readInt();
            System.out.println(socket + "tlen = " + totalLength + ", fragcount = " + fcount);
            byte[] buf = null;
            String handlerId = null;
            SocketTransceiver st = null;
            int flen = 0;
            switch (opcode) {
                case 2: {
                    flen = in.readInt();
                    buf = new byte[flen];
                    in.read(buf);
                    handlerId = new String(buf);
                    st = new SocketTransceiver(socket, peer_pid);
                    this.handlerList.put(handlerId, st);
                    break;
                }
                case 1: {
                    flen = in.readInt();
                    buf = new byte[flen];
                    in.read(buf);
                    handlerId = new String(buf);
                    st = (SocketTransceiver)this.handlerList.get(handlerId);
                    if (st == null) {
                        throw new Exception("no such handler : " + handlerId);
                    }
                    st.sendSocket(socket);
                    break;
                }
                default: {
                    throw new Exception("unknown opcode : " + opcode);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                socket.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void run() {
        System.out.println("[TestListener] started");
        Socket socket = null;
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port);
            while (this.running) {
                try {
                    socket = serverSocket.accept();
                    if (!this.running) break;
                    this.handle(socket);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    try {
                        serverSocket.close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    serverSocket = new ServerSocket(this.port);
                }
            }
            serverSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("[TestListener] shutdowned");
    }

    public static void main(String[] argv) throws Exception {
        int port = 8888;
        if (argv != null && argv.length > 0) {
            try {
                port = Integer.parseInt(argv[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        TestListener listener = new TestListener(port);
        listener.start();
    }
}

