/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.internal.runners.TestIntrospector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeforeAndAfterRunner {
    private final Class<? extends Annotation> fBeforeAnnotation;
    private final Class<? extends Annotation> fAfterAnnotation;
    private TestIntrospector fTestIntrospector;
    private Object fTest;

    public BeforeAndAfterRunner(Class<?> testClass, Class<? extends Annotation> beforeAnnotation, Class<? extends Annotation> afterAnnotation, Object test) {
        this.fBeforeAnnotation = beforeAnnotation;
        this.fAfterAnnotation = afterAnnotation;
        this.fTestIntrospector = new TestIntrospector(testClass);
        this.fTest = test;
    }

    public void runProtected() {
        try {
            try {
                this.runBefores();
                this.runUnprotected();
            }
            catch (FailedBefore failedBefore) {}
        }
        finally {
            this.runAfters();
        }
    }

    protected abstract void runUnprotected();

    protected abstract void addFailure(Throwable var1);

    private void runBefores() throws FailedBefore {
        try {
            List<Method> befores = this.fTestIntrospector.getTestMethods(this.fBeforeAnnotation);
            for (Method before : befores) {
                this.invokeMethod(before);
            }
        }
        catch (InvocationTargetException e) {
            this.addFailure(e.getTargetException());
            throw new FailedBefore();
        }
        catch (Throwable e) {
            this.addFailure(e);
            throw new FailedBefore();
        }
    }

    private void runAfters() {
        List<Method> afters = this.fTestIntrospector.getTestMethods(this.fAfterAnnotation);
        for (Method after : afters) {
            try {
                this.invokeMethod(after);
            }
            catch (InvocationTargetException e) {
                this.addFailure(e.getTargetException());
            }
            catch (Throwable e) {
                this.addFailure(e);
            }
        }
    }

    private void invokeMethod(Method method) throws Exception {
        method.invoke(this.fTest, new Object[0]);
    }

    private static class FailedBefore
    extends Exception {
        private static final long serialVersionUID = 1L;

        FailedBefore() {
        }
    }
}

