/*
 * Decompiled with CFR 0.152.
 */
package com.dsjdf.jdf;

import com.dsjdf.jdf.CharConversion;
import com.dsjdf.jdf.Message;
import com.dsjdf.jdf.MessageException;
import java.util.Hashtable;
import java.util.Properties;

public abstract class GeneralMessageStore
implements Message {
    protected static Properties messages = null;
    private String code = null;
    private String message = null;
    private Hashtable args = new Hashtable();

    public GeneralMessageStore() throws MessageException {
        this.initialize();
    }

    public GeneralMessageStore(String code) throws MessageException {
        this();
        this.setCode(code);
    }

    public String getCode() {
        return this.code;
    }

    protected abstract void initialize() throws MessageException;

    private String parseMessage(String s) {
        if (s == null) {
            return "Cannot find message which is coded " + this.getCode();
        }
        StringBuffer content = new StringBuffer();
        while (s.length() > 0) {
            String remainder;
            int markEndPos;
            int position = s.indexOf("<@");
            if (position == -1) {
                content.append(s);
                break;
            }
            if (position != 0) {
                content.append(s.substring(0, position));
            }
            if (s.length() == position + 2 || (markEndPos = (remainder = s.substring(position + 2)).indexOf(">")) == -1) break;
            String argname = remainder.substring(0, markEndPos).trim();
            String value = (String)this.args.get(argname);
            if (value != null) {
                content.append(value);
            }
            if (remainder.length() == markEndPos + 1) break;
            s = remainder.substring(markEndPos + 1);
        }
        return content.toString();
    }

    public void setArg(String key, String value) {
        if (value == null) {
            value = "";
        }
        this.args.put(key, value);
    }

    public void setCode(String code) {
        this.code = code;
        this.message = CharConversion.E2K((String)messages.get(code));
    }

    public String toString() {
        return this.parseMessage(this.message);
    }
}

