/*
 * Decompiled with CFR 0.152.
 */
package com.dsjdf.jdf;

import com.dsjdf.jdf.Configuration;
import com.dsjdf.jdf.DateTime;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public abstract class LoggerWriter {
    private static PrintWriter writer = null;
    private static final Object lock = new Object();
    private static String today = null;
    private static boolean newLined = true;
    public static final int SYS = 0;
    public static final int ERR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    public static final int DBWRAP = 5;
    private int mode;
    private static String lineSeparator = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerWriter(int mode) {
        this.mode = mode;
        Object object = lock;
        synchronized (object) {
            LoggerWriter.checkDate();
        }
    }

    private static void checkDate() {
        String day = DateTime.getShortDateString();
        if (day.equals(today)) {
            return;
        }
        try {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                writer = null;
            }
            today = day;
            String logname = String.valueOf(today) + ".log";
            Configuration conf = new Configuration();
            String directory = conf.get("logger.dir").trim();
            File file = new File(directory, logname);
            String filename = file.getAbsolutePath();
            FileWriter fw = new FileWriter(filename, true);
            boolean autoflush = true;
            try {
                autoflush = conf.getBoolean("logger.autoflush");
            }
            catch (IllegalArgumentException ee) {
                autoflush = true;
            }
            writer = new PrintWriter((Writer)new BufferedWriter(fw), autoflush);
        }
        catch (Exception e) {
            writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(System.out)), true);
            writer.println("Can't open log file : " + e.getMessage());
            writer.println("Log will be printed into System.out");
        }
    }

    public void finalize() {
        try {
            if (writer != null) {
                writer.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void flush() {
        if (this.isPrintMode()) {
            writer.flush();
        }
    }

    protected abstract String getPrefixInfo(Object var1);

    private boolean isPrintMode() {
        boolean isPrintable = true;
        try {
            Configuration conf = new Configuration();
            switch (this.mode) {
                case 0: {
                    isPrintable = conf.getBoolean("logger.sys.trace");
                    break;
                }
                case 1: {
                    isPrintable = conf.getBoolean("logger.err.trace");
                    break;
                }
                case 2: {
                    isPrintable = conf.getBoolean("logger.warn.trace");
                    break;
                }
                case 3: {
                    isPrintable = conf.getBoolean("logger.info.trace");
                    break;
                }
                case 4: {
                    isPrintable = conf.getBoolean("logger.debug.trace");
                    break;
                }
                case 5: {
                    isPrintable = conf.getBoolean("logger.dbwrap.trace");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isPrintable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object p, Object x) {
        if (!this.isPrintMode()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (newLined) {
                this.printTime();
            }
            writer.print(this.getPrefixInfo(p));
            writer.print(x);
            newLined = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object p, Object x) {
        if (!this.isPrintMode()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (newLined) {
                this.printTime();
            }
            writer.print(this.getPrefixInfo(p));
            writer.println(x);
            newLined = true;
        }
    }

    private void printTime() {
        LoggerWriter.checkDate();
        String serverty = " ";
        switch (this.mode) {
            case 0: {
                serverty = "SYS";
                break;
            }
            case 1: {
                serverty = "ERR";
                break;
            }
            case 2: {
                serverty = "WARN";
                break;
            }
            case 3: {
                serverty = "INFO";
                break;
            }
            case 4: {
                serverty = "DEBUG";
                break;
            }
            case 5: {
                serverty = "DBWRAP";
            }
        }
        writer.write("[" + serverty + "] [" + DateTime.getShortTimeString() + "]" + ' ');
    }

    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int off, int len) {
        if (!this.isPrintMode()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (newLined) {
                this.printTime();
            }
            writer.write(buf, off, len);
            newLined = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) {
        if (!this.isPrintMode()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (newLined) {
                this.printTime();
            }
            writer.write(c);
            newLined = false;
        }
    }

    public void write(String s) {
        this.write(s, 0, s.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len) {
        if (!this.isPrintMode()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (newLined) {
                this.printTime();
            }
            writer.write(s, off, len);
            newLined = false;
        }
    }
}

