/*
 * Decompiled with CFR 0.152.
 */
package com.dsjdf.server;

import com.dsjdf.jdf.Config;
import com.dsjdf.jdf.Configuration;
import com.dsjdf.jdf.ConfigurationException;
import com.dsjdf.jdf.Logger;
import com.dsjdf.jdf.MessageException;
import com.dsjdf.jdf.MessageStore;
import com.dsjdf.jdf.Utility;
import com.dsjdf.server.DSServerLauncherStore;
import com.dsjdf.server.DSSocketServer;
import com.dsjdf.server.DefaultDSSocketServer;
import com.dsjdf.server.watchdog.DSWatchDog;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;

public class DSServerLauncher {
    private Hashtable serverMap;
    private Thread controlServer;
    Thread watchDog;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DSServerLauncher() {
        Configuration conf = null;
        try {
            conf = new Configuration();
        }
        catch (ConfigurationException e) {
            try {
                MessageStore msg = new MessageStore("SYS009");
                Logger.sys.println(this, msg);
                System.out.println(msg.toString());
            }
            catch (MessageException e1) {
                Logger.sys.println(this, e1.getMessage());
            }
            return;
        }
        System.out.println("");
        System.out.println("-----------------------------------------------------");
        System.out.println("DSJDF Server Launcher v.1.00");
        System.out.println("");
        System.out.println("Copyright 2005 DreamSecurity. co. Ltd.");
        System.out.println("All rights reserved.");
        System.out.println("-----------------------------------------------------");
        try {
            String passwd;
            boolean isUseControlServer = false;
            try {
                isUseControlServer = conf.getBoolean("server.isUseControlServer");
            }
            catch (Exception e) {
                isUseControlServer = false;
            }
            if (isUseControlServer && ((passwd = conf.get("control_server.connectionPassword")) == null || passwd != null && passwd.length() == 0)) {
                System.out.println("You do not set control server password!");
                System.out.println("You must set the password in properties file to use control server.");
                System.out.println("");
                System.out.println("Exit DSJDF server launcher.");
                System.out.println("");
                return;
            }
            int serverCnt = conf.getInt("server.count");
            if (!this.checkServerProfile(serverCnt, conf)) {
                MessageStore msg = new MessageStore("SYS014");
                Logger.sys.println(this, msg);
                System.out.println(msg.toString());
                System.out.println("Exit DSJDF server launcher.");
                return;
            }
            this.serverMap = new Hashtable(serverCnt);
            try {
                int i = 0;
                while (i < serverCnt) {
                    String serverName = conf.get("server.name." + (i + 1)).trim();
                    System.out.println(String.valueOf(serverName) + " server initializing...");
                    String className = conf.get(String.valueOf(serverName) + ".serversocket.class");
                    DSSocketServer serverThread = null;
                    Class<?> keeperClass = Class.forName(className);
                    Class[] argsTypes = new Class[2];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    argsTypes[0] = clazz;
                    argsTypes[1] = Integer.TYPE;
                    Constructor<?> cons = keeperClass.getConstructor(argsTypes);
                    Object[] args = new Object[]{serverName, new Integer(0)};
                    serverThread = (DSSocketServer)cons.newInstance(args);
                    serverThread.setThisObject(serverThread);
                    this.serverMap.put(serverName, serverThread);
                    System.out.println(String.valueOf(serverName) + " server initialized...");
                    ++i;
                }
            }
            catch (Exception e) {
                Logger.debug.println(this, Utility.getStackTrace(e));
                MessageStore msg = new MessageStore("SYS010");
                Logger.sys.println(this, msg);
                System.out.println(msg.toString());
                System.out.println("Exit DSJDF server launcher.");
                return;
            }
            if (isUseControlServer) {
                System.out.println("control server initializing...");
                this.controlServer = new DefaultDSSocketServer("control_server", 1);
                this.controlServer.start();
                System.out.println("control server start...");
            }
            this.watchDog = new Thread(new DSWatchDog(this));
            System.out.println("DSJDF Watchdog initialize...");
            this.watchDog.start();
            System.out.println("DSJDF Watchdog start...");
            Enumeration serverThreadEnum = this.serverMap.elements();
            int c = 0;
            while (serverThreadEnum.hasMoreElements()) {
                DSSocketServer socketThread = (DSSocketServer)serverThreadEnum.nextElement();
                socketThread.start();
                String serverName = conf.get("server.name." + (c + 1)).trim();
                String className = conf.get(String.valueOf(serverName) + ".serversocket.class");
                ++c;
                MessageStore msg = new MessageStore("MSG013");
                msg.setArg("servername", serverName);
                msg.setArg("className", className);
                Logger.info.println(this, msg);
                System.out.println(String.valueOf(serverName) + " server start...");
            }
            Thread hook = new Thread(){

                public void run() {
                    MessageStore msg = new MessageStore("MSG011");
                    Logger.info.println(this, msg);
                    System.out.println(msg.toString());
                }
            };
            hook.setName("Shutdown DSServerLauncher");
            Runtime.getRuntime().addShutdownHook(hook);
        }
        catch (IllegalArgumentException e) {
            try {
                MessageStore msg = new MessageStore("SYS016");
                Logger.sys.println(this, msg);
                System.out.println(msg.toString());
            }
            catch (MessageException ee) {
                Logger.sys.println(this, "Wrong type or null data in configuration file as run ServerLauncher. Exit DSJDF server launcher.");
            }
        }
        catch (Exception e) {
            MessageStore msg = new MessageStore("MSG011");
            Logger.info.println(this, msg);
        }
    }

    public Hashtable getServerMap() {
        return this.serverMap;
    }

    public void setServerMap(Hashtable serverMap) {
        this.serverMap = serverMap;
    }

    public Thread getControlServer() {
        return this.controlServer;
    }

    private boolean checkServerProfile(int serverCnt, Config conf) {
        boolean ret = true;
        if (serverCnt <= 0) {
            ret = false;
        } else {
            try {
                int i = 0;
                while (i < serverCnt) {
                    String string = conf.get("server.name." + (i + 1));
                    ++i;
                }
            }
            catch (IllegalArgumentException e) {
                ret = false;
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        DSServerLauncher launcher = new DSServerLauncher();
        DSServerLauncherStore launcherStore = DSServerLauncherStore.getInstance();
        launcherStore.setDSServerLauncher(launcher);
    }
}

