/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.io;

import com.dsjdf.jdf.ConfigurationException;
import com.dsjdf.jdf.Logger;
import com.dsjdf.jdf.Utility;
import com.gpki.secureweb.GPKIKeyInfo;
import com.gpki.util.CryptoTagFinder;
import com.gpki.util.GPKIUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

public class GPKIPrintWriter
extends PrintWriter {
    GPKIKeyInfo keyinfo;
    private CryptoTagFinder finder;
    private boolean isFinding = false;

    public GPKIPrintWriter(Writer out, GPKIKeyInfo keyinfo) throws IOException {
        super(out);
        this.keyinfo = keyinfo;
        this.init();
    }

    public GPKIPrintWriter(OutputStream out, boolean autoFlush) throws IOException {
        super(out, autoFlush);
        this.init();
    }

    public GPKIPrintWriter(OutputStream out) throws IOException {
        super(out);
        this.init();
    }

    public GPKIPrintWriter(Writer out) throws IOException {
        super(out);
        this.init();
    }

    public GPKIPrintWriter(Writer out, boolean autoFlush) throws IOException {
        super(out, autoFlush);
        this.init();
    }

    private void init() throws IOException {
        try {
            if (this.finder == null) {
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIPrintWriter keyinfo = " + this.keyinfo);
                this.finder = new CryptoTagFinder(this.keyinfo);
            }
        }
        catch (ConfigurationException e) {
            Logger.err.println(this, Utility.getStackTrace(e));
            throw new IOException(e.getMessage());
        }
    }

    public void print(String str) {
        List ret = null;
        try {
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \ubd80\ubd84\uc554\ud638\ud654 \ub370\uc774\ud130 : " + str);
            ret = this.finder.getDelimStringForEncrypt(str);
            int i = 0;
            while (i < ret.size()) {
                String retString = (String)ret.get(i);
                this.out.write(retString.toCharArray());
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "]" + "GPKIPrintWriter print : " + retString);
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] printerWriter ref= " + this.out.toString());
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] out.length= " + retString.length());
                ++i;
            }
        }
        catch (Exception e) {
            try {
                Logger.err.println(this, Utility.getStackTrace(e));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void println(String x) {
        this.print(x);
        if (!this.isFinding) {
            super.println();
        }
    }

    public void close() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            try {
                this.out.write(GPKIUtil.goErrorPage(e));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        super.close();
    }
}

