/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.secureweb;

import com.dsjdf.jdf.Configuration;
import com.dsjdf.jdf.Logger;
import com.dsjdf.jdf.Utility;
import com.gpki.gpkiapi.crypto.MessageDigest;
import com.gpki.gpkiapi.util.Base64;
import com.gpki.gpkiapi.util.Dump;
import com.gpki.secureweb.GPKISecureWEBDefine;
import com.gpki.secureweb.GPKISecureWEBException;
import java.util.ArrayList;

public class Base64ContentInfo
implements GPKISecureWEBDefine {
    protected static int SHA256_LENGTH = 32;
    protected byte major;
    protected byte minor;
    protected byte content_type;
    protected int length;
    protected byte[] contentInfo;

    public Base64ContentInfo() {
    }

    public Base64ContentInfo(String TAG_Base64InfoStr) throws GPKISecureWEBException {
        try {
            byte[] decodeBase64;
            if (TAG_Base64InfoStr != null || !TAG_Base64InfoStr.equals("")) {
                int startIndex = 0;
                int endIndex = 0;
                int base64InfoStrlen = TAG_Base64InfoStr.length();
                Configuration conf = new Configuration();
                int startTag = 21;
                int endTag = 22;
                startIndex = startTag;
                endIndex = base64InfoStrlen - endTag;
                String Base64InfoStr = TAG_Base64InfoStr.substring(startIndex, endIndex);
                decodeBase64 = new Base64().decode(Base64InfoStr);
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] Base64\ub85c \ub514\ucf54\ub4dc\ud55c \ub370\uc774\ud130 " + Dump.toHexString((byte[])decodeBase64, (long)0L, (long)decodeBase64.length));
                if (decodeBase64.length < 8) {
                    throw new GPKISecureWEBException("Header size error : Header size is so short!");
                }
            } else {
                Logger.err.println(this, "[" + Thread.currentThread().getName() + "] \uc554\ud638\ud654 \ub370\uc774\ud130\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                throw new GPKISecureWEBException("EncryptedData is Not Exist!");
            }
            this.major = decodeBase64[0];
            this.minor = decodeBase64[1];
            this.content_type = decodeBase64[2];
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \ubc1b\uc558\uc744\ub54c\uc758 major : " + this.major);
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \ubc1b\uc558\uc744\ub54c\uc758 minor : " + this.minor);
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \ubc1b\uc558\uc744\ub54c\uc758 content_type : " + this.content_type);
            byte[] len = new byte[4];
            System.arraycopy(decodeBase64, 3, len, 0, 4);
            this.length = Utility.ntoh(len);
            this.contentInfo = new byte[decodeBase64.length - 7];
            System.arraycopy(decodeBase64, 7, this.contentInfo, 0, decodeBase64.length - 7);
        }
        catch (Exception e) {
            Logger.err.println(this, Utility.getStackTrace(e));
            throw new GPKISecureWEBException(e);
        }
    }

    public String makeBase64ContentInfo(byte major, byte minor, byte content_type, byte[] tobeBase64Info) throws GPKISecureWEBException {
        major = this.getMajor();
        minor = this.getMinor();
        content_type = this.getContentType();
        byte[] len = new byte[4];
        len = Utility.htonl(tobeBase64Info.length);
        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \ubcf4\ub0bc\ub54c major : " + this.major);
        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \ubcf4\ub0bc\ub54c minor : " + this.minor);
        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \ubcf4\ub0bc\ub54c content_type : " + this.content_type);
        String base64ContentInfo = null;
        try {
            this.contentInfo = Utility.concat(new byte[]{major}, Utility.concat(new byte[]{minor}, Utility.concat(new byte[]{content_type}, Utility.concat(len, tobeBase64Info))));
            base64ContentInfo = new Base64().encode(this.contentInfo);
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] major : " + new byte[]{major});
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] minor : " + new byte[]{minor});
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] content_type : " + new byte[]{content_type});
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] len : " + len);
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] tobeBase64Info : " + tobeBase64Info);
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] base64ContentInfo = " + base64ContentInfo);
        }
        catch (Exception e) {
            Logger.err.println(this, Utility.getStackTrace(e));
            throw new GPKISecureWEBException(e);
        }
        return base64ContentInfo;
    }

    public static String Base64SrciptEncrypt(String raw) throws GPKISecureWEBException {
        String[] rawArr = Base64ContentInfo.splitByByte(raw, 80);
        StringBuffer buf = null;
        try {
            buf = new StringBuffer();
            buf.append("<script language ='javaScript'>\n");
            buf.append("var data = '';\n");
            buf.append("data = '" + rawArr[0] + "'");
            int i = 1;
            while (i < rawArr.length) {
                buf.append("\n     + '").append(rawArr[i]).append("'");
                ++i;
            }
            buf.append(";\n");
            buf.append("document.write(Decrypt(data));\n");
            buf.append("</script>\n");
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return buf.toString();
    }

    private static String[] splitByByte(String raw, int aLineLength) {
        if (raw == null || raw.length() == 0) {
            return new String[]{""};
        }
        int strLength = raw.length();
        ArrayList<String> al = new ArrayList<String>();
        int index = 0;
        index = 0;
        while (index + aLineLength < strLength) {
            al.add(raw.substring(index, index + aLineLength));
            index += aLineLength;
        }
        if ((index + 1) % aLineLength > 0) {
            al.add(raw.substring(index));
        }
        return al.toArray(new String[0]);
    }

    public byte getContentType() {
        return this.content_type;
    }

    public byte[] getContentInfo() {
        return this.contentInfo;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public byte[] checkMessageDigest(byte[] tobeHashed_data) throws GPKISecureWEBException {
        byte[] decdata = new byte[tobeHashed_data.length - SHA256_LENGTH];
        byte[] hash = new byte[SHA256_LENGTH];
        try {
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] checkMessageDigest length : " + this.length);
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] checkMessageDigest tobeHashed_data : " + tobeHashed_data.length);
            if (tobeHashed_data.length < SHA256_LENGTH + 1) {
                throw new GPKISecureWEBException("EncryptedData size is so short!");
            }
            int content_length = tobeHashed_data.length - SHA256_LENGTH;
            System.arraycopy(tobeHashed_data, 0, decdata, 0, content_length);
            System.arraycopy(tobeHashed_data, content_length, hash, 0, SHA256_LENGTH);
            MessageDigest sha256 = MessageDigest.getInstance((String)"SHA256");
            byte[] myHash = sha256.digest(decdata);
            if (myHash.equals(hash)) {
                throw new GPKISecureWEBException("EncryptData Integrity Errorhash = " + Dump.toHexString((byte[])hash, (long)0L, (long)hash.length) + ", " + "myHash = " + Dump.toHexString((byte[])myHash, (long)0L, (long)myHash.length));
            }
        }
        catch (Exception e) {
            Logger.err.println(this, e.getStackTrace());
            throw new GPKISecureWEBException(e);
        }
        return decdata;
    }
}

