/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.secureweb;

import com.dsjdf.jdf.Logger;
import com.gpki.gpkiapi.cms.EnvelopedData;
import com.gpki.gpkiapi.cms.WapEnvelopedData;
import com.gpki.gpkiapi.crypto.SecretKey;
import com.gpki.gpkiapi.util.Dump;
import com.gpki.secureweb.Base64ContentInfo;
import com.gpki.secureweb.GPKISecureWEBConfig;
import com.gpki.secureweb.GPKISecureWEBException;
import com.gpki.secureweb.SignContentInfo;

public class EnvelopData
extends Base64ContentInfo {
    private SignContentInfo signContentInfo;
    public SecretKey secretkey;

    public EnvelopData(String base64contentinto) throws GPKISecureWEBException {
        super(base64contentinto);
    }

    public byte[] decrypt() throws GPKISecureWEBException {
        byte[] decrypted_data = null;
        byte[] decdata = null;
        try {
            if (this.content_type == 21) {
                EnvelopedData envdata = new EnvelopedData();
                decrypted_data = envdata.process(this.contentInfo, GPKISecureWEBConfig.getServerCert(), GPKISecureWEBConfig.getPrivateKey());
                decdata = this.checkMessageDigest(decrypted_data);
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] EnvelopData decdata : " + Dump.toHexString((byte[])decdata, (long)0L, (long)decdata.length));
                this.secretkey = envdata.getSecretKey();
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] EnvelopData secertkey\uc758 \uc54c\uace0\ub9ac\uc998  : " + this.secretkey.getKeyAlg());
            } else if (this.content_type == 31) {
                WapEnvelopedData envdata = new WapEnvelopedData();
                envdata.setMyCert(GPKISecureWEBConfig.getServerCert(), GPKISecureWEBConfig.getPrivateKey());
                decrypted_data = envdata.process(this.contentInfo);
                decdata = this.checkMessageDigest(decrypted_data);
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] EnvelopData decdata : " + Dump.toHexString((byte[])decdata, (long)0L, (long)decdata.length));
                this.secretkey = envdata.getSecretKey();
            } else if (this.content_type == 23 || this.content_type == 22 || this.content_type == 32 || this.content_type == 33) {
                if (this.content_type == 33 || this.content_type == 32) {
                    WapEnvelopedData envdata = new WapEnvelopedData();
                    envdata.setMyCert(GPKISecureWEBConfig.getServerCert(), GPKISecureWEBConfig.getPrivateKey());
                    Logger.debug.println(this, "EnvelopData setMyCert \uc644\ub8cc");
                    decrypted_data = envdata.process(this.contentInfo);
                    Logger.debug.println(this, "ENVELOP_WAPSIGN_DATA decrypted_data : " + Dump.toHexString((byte[])decrypted_data, (long)0L, (long)decrypted_data.length));
                    this.secretkey = envdata.getSecretKey();
                } else {
                    EnvelopedData envdata = new EnvelopedData();
                    decrypted_data = envdata.process(this.contentInfo, GPKISecureWEBConfig.getServerCert(), GPKISecureWEBConfig.getPrivateKey());
                    Logger.debug.println(this, "(LOGIN_)ENVELOP_SIGN_DATA decrypted_data : " + Dump.toHexString((byte[])decrypted_data, (long)0L, (long)decrypted_data.length));
                    this.secretkey = envdata.getSecretKey();
                }
                this.signContentInfo = new SignContentInfo(decrypted_data);
                decdata = this.signContentInfo.getSignData();
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] EnvelopData process\uc5d0 \ub123\uc744 decdata : " + Dump.toHexString((byte[])decdata, (long)0L, (long)decdata.length));
            }
        }
        catch (Exception e) {
            Logger.err.println(this, e.getStackTrace());
            throw new GPKISecureWEBException(e);
        }
        return decdata;
    }

    public byte[] getPrivateKeyRandom() {
        return this.signContentInfo.getPrivatekeyRandom();
    }
}

