/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.secureweb;

import com.dsjdf.jdf.Config;
import com.dsjdf.jdf.Configuration;
import com.dsjdf.jdf.ConfigurationException;
import com.dsjdf.jdf.Logger;
import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.storage.Disk;
import com.gpki.secureweb.GPKISecureWEBException;

public class GPKISecureWEBConfig {
    private static GPKISecureWEBConfig gpkiConf;
    private static Config conf;

    public static GPKISecureWEBConfig getInstance() throws GPKISecureWEBException {
        try {
            if (gpkiConf == null) {
                gpkiConf = new GPKISecureWEBConfig();
            }
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return gpkiConf;
    }

    public GPKISecureWEBConfig() throws GPKISecureWEBException {
        try {
            conf = new Configuration();
        }
        catch (ConfigurationException e) {
            Logger.err.println(this, e.getStackTrace());
            throw new GPKISecureWEBException(e);
        }
    }

    public static X509Certificate getServerCert() throws GPKISecureWEBException {
        X509Certificate cert = null;
        try {
            cert = Disk.readCert((String)conf.getString("GPKISecureWeb.CertFilePathName"));
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return cert;
    }

    public static PrivateKey getPrivateKey() throws GPKISecureWEBException {
        PrivateKey prikey;
        try {
            prikey = Disk.readPriKey((String)conf.getString("GPKISecureWeb.PrivateKeyFilePathName"), (String)conf.getString("GPKISecureWeb.PrivateKeyPasswd"));
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return prikey;
    }

    public static String getAlgo() throws GPKISecureWEBException {
        try {
            return conf.getString("GPKISecureWeb.crypto.algo");
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
    }

    public static String getGPKIAPIConfFilePath() throws GPKISecureWEBException {
        String GPKIConfFilePath = null;
        try {
            GPKIConfFilePath = conf.getString("GPKISecureWeb.gpkiapi.ConfFilePath");
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return GPKIConfFilePath;
    }

    public static String getAnyPolicy() throws GPKISecureWEBException {
        String anyPolicy = null;
        try {
            anyPolicy = conf.getString("GPKISecureWeb.AnyPolicy");
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return anyPolicy;
    }

    public static String getPolicies() throws GPKISecureWEBException {
        String policies = null;
        try {
            policies = conf.getString("GPKISecureWeb.Policy");
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return policies;
    }

    public static String getCheckChallenge() throws GPKISecureWEBException {
        String confChallenge = null;
        try {
            confChallenge = conf.getString("GPKISecureWeb.CheckChallenge");
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return confChallenge;
    }
}

