/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.hssf.util.CellRangeAddressList;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public final class DVRecord
extends Record {
    public static final short sid = 446;
    private static final UnicodeString NULL_TEXT_STRING = new UnicodeString("\u0000");
    private int _option_flags;
    private UnicodeString _promptTitle;
    private UnicodeString _errorTitle;
    private UnicodeString _promptText;
    private UnicodeString _errorText;
    private short _not_used_1 = (short)16352;
    private Ptg[] _formula1;
    private short _not_used_2 = 0;
    private Ptg[] _formula2;
    private CellRangeAddressList _regions;
    private static final BitField opt_data_type = new BitField(15);
    private static final BitField opt_error_style = new BitField(112);
    private static final BitField opt_string_list_formula = new BitField(128);
    private static final BitField opt_empty_cell_allowed = new BitField(256);
    private static final BitField opt_suppress_dropdown_arrow = new BitField(512);
    private static final BitField opt_show_prompt_on_cell_selected = new BitField(262144);
    private static final BitField opt_show_error_on_invalid_value = new BitField(524288);
    private static final BitField opt_condition_operator = new BitField(0x700000);

    public DVRecord(int validationType, int operator, int errorStyle, boolean emptyCellAllowed, boolean suppressDropDownArrow, boolean isExplicitList, boolean showPromptBox, String promptTitle, String promptText, boolean showErrorBox, String errorTitle, String errorText, Ptg[] formula1, Ptg[] formula2, CellRangeAddressList regions) {
        int flags = 0;
        flags = opt_data_type.setValue(flags, validationType);
        flags = opt_condition_operator.setValue(flags, operator);
        flags = opt_error_style.setValue(flags, errorStyle);
        flags = opt_empty_cell_allowed.setBoolean(flags, emptyCellAllowed);
        flags = opt_suppress_dropdown_arrow.setBoolean(flags, suppressDropDownArrow);
        flags = opt_string_list_formula.setBoolean(flags, isExplicitList);
        flags = opt_show_prompt_on_cell_selected.setBoolean(flags, showPromptBox);
        this._option_flags = flags = opt_show_error_on_invalid_value.setBoolean(flags, showErrorBox);
        this._promptTitle = DVRecord.resolveTitleText(promptTitle);
        this._promptText = DVRecord.resolveTitleText(promptText);
        this._errorTitle = DVRecord.resolveTitleText(errorTitle);
        this._errorText = DVRecord.resolveTitleText(errorText);
        this._formula1 = formula1;
        this._formula2 = formula2;
        this._regions = regions;
    }

    public DVRecord(RecordInputStream in) {
        this._option_flags = in.readInt();
        this._promptTitle = DVRecord.readUnicodeString(in);
        this._errorTitle = DVRecord.readUnicodeString(in);
        this._promptText = DVRecord.readUnicodeString(in);
        this._errorText = DVRecord.readUnicodeString(in);
        int field_size_first_formula = in.readUShort();
        this._not_used_1 = in.readShort();
        this._formula1 = Ptg.readTokens(field_size_first_formula, in);
        int field_size_sec_formula = in.readUShort();
        this._not_used_2 = in.readShort();
        this._formula2 = Ptg.readTokens(field_size_sec_formula, in);
        this._regions = new CellRangeAddressList(in);
    }

    public int getDataType() {
        return opt_data_type.getValue(this._option_flags);
    }

    public int getErrorStyle() {
        return opt_error_style.getValue(this._option_flags);
    }

    public boolean getListExplicitFormula() {
        return opt_string_list_formula.isSet(this._option_flags);
    }

    public boolean getEmptyCellAllowed() {
        return opt_empty_cell_allowed.isSet(this._option_flags);
    }

    public boolean getSuppressDropdownArrow() {
        return opt_suppress_dropdown_arrow.isSet(this._option_flags);
    }

    public boolean getShowPromptOnCellSelected() {
        return opt_show_prompt_on_cell_selected.isSet(this._option_flags);
    }

    public boolean getShowErrorOnInvalidValue() {
        return opt_show_error_on_invalid_value.isSet(this._option_flags);
    }

    public int getConditionOperator() {
        return opt_condition_operator.getValue(this._option_flags);
    }

    public CellRangeAddressList getCellRangeAddress() {
        return this._regions;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[DV]\n");
        sb.append(" options=").append(Integer.toHexString(this._option_flags));
        sb.append(" title-prompt=").append(DVRecord.formatTextTitle(this._promptTitle));
        sb.append(" title-error=").append(DVRecord.formatTextTitle(this._errorTitle));
        sb.append(" text-prompt=").append(DVRecord.formatTextTitle(this._promptText));
        sb.append(" text-error=").append(DVRecord.formatTextTitle(this._errorText));
        sb.append("\n");
        this.appendFormula(sb, "Formula 1:", this._formula1);
        this.appendFormula(sb, "Formula 2:", this._formula2);
        sb.append("Regions: ");
        int nRegions = this._regions.countRanges();
        for (int i = 0; i < nRegions; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            CellRangeAddress addr = this._regions.getCellRangeAddress(i);
            sb.append('(').append(addr.getFirstRow()).append(',').append(addr.getLastRow());
            sb.append(',').append(addr.getFirstColumn()).append(',').append(addr.getLastColumn()).append(')');
        }
        sb.append("\n");
        sb.append("[/DV]");
        return sb.toString();
    }

    private static String formatTextTitle(UnicodeString us) {
        String str = us.getString();
        if (str.length() == 1 && str.charAt(0) == '\u0000') {
            return "'\\0'";
        }
        return str;
    }

    private void appendFormula(StringBuffer sb, String label, Ptg[] ptgs) {
        sb.append(label);
        if (ptgs.length < 1) {
            sb.append("<empty>\n");
            return;
        }
        sb.append("\n");
        for (int i = 0; i < ptgs.length; ++i) {
            sb.append('\t').append(ptgs[i].toString()).append('\n');
        }
    }

    public int serialize(int offset, byte[] data) {
        int size = this.getRecordSize();
        LittleEndian.putShort(data, 0 + offset, (short)446);
        LittleEndian.putShort(data, 2 + offset, (short)(size - 4));
        int pos = 4;
        LittleEndian.putInt(data, pos + offset, this._option_flags);
        pos += 4;
        pos += DVRecord.serializeUnicodeString(this._promptTitle, pos + offset, data);
        pos += DVRecord.serializeUnicodeString(this._errorTitle, pos + offset, data);
        pos += DVRecord.serializeUnicodeString(this._promptText, pos + offset, data);
        pos += DVRecord.serializeUnicodeString(this._errorText, pos + offset, data);
        LittleEndian.putUShort(data, offset + pos, Ptg.getEncodedSize(this._formula1));
        LittleEndian.putUShort(data, offset + (pos += 2), this._not_used_1);
        pos += 2;
        pos += Ptg.serializePtgs(this._formula1, data, pos + offset);
        LittleEndian.putUShort(data, offset + pos, Ptg.getEncodedSize(this._formula2));
        LittleEndian.putShort(data, offset + (pos += 2), this._not_used_2);
        pos += 2;
        pos += Ptg.serializePtgs(this._formula2, data, pos + offset);
        this._regions.serialize(pos + offset, data);
        return size;
    }

    private static UnicodeString resolveTitleText(String str) {
        if (str == null || str.length() < 1) {
            return NULL_TEXT_STRING;
        }
        return new UnicodeString(str);
    }

    private static UnicodeString readUnicodeString(RecordInputStream in) {
        return new UnicodeString(in);
    }

    private static int serializeUnicodeString(UnicodeString us, int offset, byte[] data) {
        UnicodeString.UnicodeRecordStats urs = new UnicodeString.UnicodeRecordStats();
        us.serialize(urs, offset, data);
        return urs.recordSize;
    }

    private static int getUnicodeStringSize(UnicodeString str) {
        return 3 + str.getString().length();
    }

    public int getRecordSize() {
        int size = 16;
        size += DVRecord.getUnicodeStringSize(this._promptTitle);
        size += DVRecord.getUnicodeStringSize(this._errorTitle);
        size += DVRecord.getUnicodeStringSize(this._promptText);
        size += DVRecord.getUnicodeStringSize(this._errorText);
        size += Ptg.getEncodedSize(this._formula1);
        size += Ptg.getEncodedSize(this._formula2);
        return size += this._regions.getSize();
    }

    public short getSid() {
        return 446;
    }

    public Object clone() {
        return this.cloneViaReserialise();
    }
}

