/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.util.HashMap;
import jeus.xml.binding.connectorHelper.ConnectionDefinitionsDescriptor;

public final class ConnectionPoolInfo {
    private boolean reauthenticationSupport;
    private final boolean basicPasswordEnabled;
    private boolean skipMatching;
    private boolean working;
    private final boolean waitConnection;
    private boolean useWrapper;
    private int min;
    private final int max;
    private int maxWaiter;
    private int maxDisposableCount;
    private int waitTrial;
    private final int txType;
    private long waitingTime;
    private long pooledTimeout;
    private long dissociationTimeout;
    private long invalidationTimeout;
    private long validationTimeout;
    private final String username;
    private final String password;
    private final String moduleName;
    private final String appName;
    private final String exportName;

    public ConnectionPoolInfo(String moduleName, String appName, ConnectionDefinitionsDescriptor desc) {
        this.reauthenticationSupport = desc.isReauthenticationSupport();
        this.basicPasswordEnabled = this.checkAuthenticationInfo(desc.getAuthenticationInfo());
        this.skipMatching = desc.getSkipMatching();
        this.waitConnection = desc.getWaiting();
        this.useWrapper = desc.getUseWrapper();
        this.min = desc.getMin();
        this.max = desc.getMax();
        this.maxWaiter = desc.getMaxWaiterCount();
        this.maxDisposableCount = desc.getMaxDisposableCount();
        if (this.waitConnection) {
            this.waitTrial = desc.getWaitTrial();
        }
        this.txType = desc.getTransactionSupport();
        if (this.waitConnection) {
            this.waitingTime = desc.getWaitingTime();
        }
        this.pooledTimeout = desc.getResizingPeriod();
        this.dissociationTimeout = desc.getDissociationTimeout();
        this.invalidationTimeout = desc.getInvalidationTimeout();
        this.validationTimeout = desc.getValidationTimeout();
        this.username = desc.getUserName();
        this.password = desc.getPassword();
        this.moduleName = moduleName;
        this.appName = appName;
        this.exportName = desc.getExportName();
    }

    private boolean checkAuthenticationInfo(HashMap authInfo) {
        for (String type : authInfo.keySet()) {
            if (!type.equals("BasicPassword") || !authInfo.get(type).equals("javax.resource.spi.security.PasswordCredential")) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer("ConnectionPoolInfo{");
        buf.append("reauthenticationSupport=").append(this.isReauthenticationSupport());
        buf.append(", isBasicPasswordEnabled=").append(this.isBasicPasswordEnabled());
        buf.append(", username='").append(this.getUsername());
        buf.append("', password='").append(this.getPassword());
        buf.append("', appName='").append(this.getAppName());
        buf.append("', exportName='").append(this.getExportName());
        buf.append("', min=").append(this.getMin());
        buf.append(", max=").append(this.getMax());
        buf.append(", waitTrial=").append(this.getWaitTrial());
        buf.append(", waitingTime=").append(this.getWaitingTime());
        buf.append(", waiting=").append(this.isWaitConnection());
        buf.append(", resizingPeriod=").append(this.getPooledTimeout());
        buf.append(", shrinking=").append(this.getPooledTimeout() > 0L);
        buf.append(", useWrapper=").append(this.isUseWrapper());
        buf.append(", txSupport=").append(this.getTxType());
        buf.append("}");
        return buf.toString();
    }

    boolean isReauthenticationSupport() {
        return this.reauthenticationSupport;
    }

    final void setReauthenticationSupport(boolean support) {
        this.reauthenticationSupport = support;
    }

    private boolean isBasicPasswordEnabled() {
        return this.basicPasswordEnabled;
    }

    public final boolean isSkipMatching() {
        return this.skipMatching;
    }

    public final void setSkipMatching(boolean skipMatching) {
        this.skipMatching = skipMatching;
    }

    public final boolean isWorking() {
        return this.working;
    }

    final void setWorking(boolean working) {
        this.working = working;
    }

    boolean isWaitConnection() {
        return this.waitConnection;
    }

    public boolean isUseWrapper() {
        return this.useWrapper;
    }

    final void setUseWrapper(boolean useWrapper) {
        this.useWrapper = useWrapper;
    }

    public int getMin() {
        return this.min;
    }

    public final void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public final int getMaxWaiter() {
        return this.maxWaiter;
    }

    public final void setMaxWaiter(int maxWaiter) {
        this.maxWaiter = maxWaiter;
    }

    public final int getMaxDisposableCount() {
        return this.maxDisposableCount;
    }

    public final void setMaxDisposableCount(int maxDisposableCount) {
        this.maxDisposableCount = maxDisposableCount;
    }

    public int getWaitTrial() {
        return this.waitTrial;
    }

    public final void setWaitTrial(int waitTrial) {
        this.waitTrial = waitTrial;
    }

    int getTxType() {
        return this.txType;
    }

    public long getWaitingTime() {
        return this.waitingTime;
    }

    public final void setWaitingTime(long waitingTime) {
        this.waitingTime = waitingTime;
    }

    public long getPooledTimeout() {
        return this.pooledTimeout;
    }

    final void setPooledTimeout(long pooledTimeout) {
        this.pooledTimeout = pooledTimeout;
    }

    public long getDissociationTimeout() {
        return this.dissociationTimeout;
    }

    final void setDissociationTimeout(long dissociationTimeout) {
        this.dissociationTimeout = dissociationTimeout;
    }

    public long getInvalidationTimeout() {
        return this.invalidationTimeout;
    }

    final void setInvalidationTimeout(long invalidationTimeout) {
        this.invalidationTimeout = invalidationTimeout;
    }

    public long getValidationTimeout() {
        return this.validationTimeout;
    }

    final void setValidationTimeout(long validationTimeout) {
        this.validationTimeout = validationTimeout;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getModuleName() {
        return this.moduleName;
    }

    String getAppName() {
        return this.appName;
    }

    String getExportName() {
        return this.exportName;
    }
}

