/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.util.BitSet;
import java.util.HashSet;
import javax.resource.spi.ConnectionRequestInfo;
import javax.security.auth.Subject;
import jeus.connector.ConnectionWaitTimeoutException;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA0;

final class ConnectionPoolTicket
extends HashSet {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");
    private boolean handed;
    private boolean skipmatch;
    private BitSet failure;
    private int age;
    private int index;
    private long startTime;
    private long timeout;
    private int remainingCount;
    private final ConnectionRequestInfo info;
    private final Subject subject;

    ConnectionPoolTicket(ConnectionRequestInfo info, Subject subject) {
        this.info = info;
        this.subject = subject;
    }

    ConnectionPoolTicket(ConnectionRequestInfo info, Subject subject, int age, long timeout, int count) {
        this(info, subject);
        this.age = age;
        this.startTime = System.currentTimeMillis();
        this.timeout = timeout;
        this.remainingCount = count;
    }

    boolean isAcceptable(int index) {
        if (this.failure == null) {
            return true;
        }
        return !this.failure.get(index);
    }

    boolean isHanded() {
        return this.handed;
    }

    boolean isSkipMatch() {
        return this.skipmatch;
    }

    int getAge() {
        return this.age;
    }

    ConnectionRequestInfo getConnectionRequestInfo() {
        return this.info;
    }

    Subject getSubject() {
        return this.subject;
    }

    int getNumOfFailed() {
        if (this.failure == null) {
            return 0;
        }
        return this.failure.cardinality();
    }

    void matchFailed(int index) {
        if (this.failure == null) {
            this.failure = new BitSet();
        }
        this.failure.set(index);
        --this.remainingCount;
    }

    void setAge(int age) {
        int oldAge = this.age;
        this.age = age;
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("age changed from " + oldAge + " to " + age);
        }
    }

    void setHanded(boolean handed) {
        this.handed = handed;
    }

    void setSkipMatch(boolean skipMatch) {
        this.skipmatch = skipMatch;
    }

    void setIndex(int index) {
        this.index = index;
    }

    synchronized int waitAndGetIndex() throws ConnectionWaitTimeoutException {
        if (!this.isHanded()) {
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.isHanded()) {
            if (logger.isLoggable(JeusMessage_JCA0._1029_LEVEL)) {
                logger.log(JeusMessage_JCA0._1029_LEVEL, JeusMessage_JCA0._1029, (Object)String.valueOf(this.index));
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("-------------- connection handed : " + this.index);
            }
            return this.index;
        }
        throw new ConnectionWaitTimeoutException();
    }

    long getRemainingTime() {
        return this.startTime + this.timeout - System.currentTimeMillis();
    }

    int getRemainingCount() {
        return this.remainingCount;
    }

    boolean isExpired() {
        return this.remainingCount <= 0 || this.timeout <= System.currentTimeMillis() - this.startTime;
    }
}

