/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import jeus.connector.ConnectorUtility;
import jeus.connector.ManagedConnectionManager;
import jeus.container.resource.ResourceRefHelper;
import jeus.jndi.jns.common.PropertyReference;
import jeus.management.j2ee.JCAConnectionFactory;
import jeus.management.j2ee.JCAResource;
import jeus.management.j2ee.ResourceAdapterModule;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA0;
import jeus.xml.binding.j2ee.ConfigPropertyType;
import jeus.xml.binding.jeusDD.ConnectorPropertyType;

public class ConnectorFactory
implements ObjectFactory {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        JCAResource jca;
        PropertyReference ref = (PropertyReference)obj;
        String moduleName = (String)ref.get(0).getContent();
        String exportName = (String)ref.get(1).getContent();
        if (logger.isLoggable(JeusMessage_JCA0._1201_LEVEL)) {
            logger.log(JeusMessage_JCA0._1201_LEVEL, JeusMessage_JCA0._1201, new Object[]{exportName, moduleName});
        }
        if ((jca = ResourceAdapterModule.getJCAResource(moduleName)) == null) {
            logger.log(JeusMessage_JCA0._1202_LEVEL, JeusMessage_JCA0._1202, (Object)moduleName);
            throw new Exception("connector module " + moduleName + " is not exists");
        }
        JCAConnectionFactory jcaf = jca.getJCAConnectionFactory(exportName);
        if (jcaf == null) {
            logger.log(JeusMessage_JCA0._1203_LEVEL, JeusMessage_JCA0._1203, (Object)exportName);
            throw new Exception("connection pool " + exportName + " is not exists");
        }
        Properties profile = ref.getProperties();
        boolean shareable = ResourceRefHelper.fetchShareable(profile);
        Resource.AuthenticationType resAuthType = ResourceRefHelper.fetchAppAuth(profile);
        ManagedConnectionManager mcm = new ManagedConnectionManager(jcaf.getConnectionPool(), jca.isStandalone(), shareable, resAuthType);
        if (logger.isLoggable(JeusMessage_JCA0._1204_LEVEL)) {
            logger.log(JeusMessage_JCA0._1204_LEVEL, JeusMessage_JCA0._1204);
        }
        return jcaf.getManagedConnectionFactory().createConnectionFactory((ConnectionManager)mcm);
    }

    public static ManagedConnectionFactory getManagedConnectionFactory(String moduleName, String exportName) {
        JCAResource jca;
        if (logger.isLoggable(JeusMessage_JCA0._1205_LEVEL)) {
            logger.log(JeusMessage_JCA0._1205_LEVEL, JeusMessage_JCA0._1205, new Object[]{exportName, moduleName});
        }
        if ((jca = ResourceAdapterModule.getJCAResource(moduleName)) == null) {
            logger.log(JeusMessage_JCA0._1206_LEVEL, JeusMessage_JCA0._1206, (Object)moduleName);
            return null;
        }
        JCAConnectionFactory jcaf = jca.getJCAConnectionFactory(exportName);
        if (jcaf == null) {
            logger.log(JeusMessage_JCA0._1207_LEVEL, JeusMessage_JCA0._1207, (Object)exportName);
            return null;
        }
        if (logger.isLoggable(JeusMessage_JCA0._1208_LEVEL)) {
            logger.log(JeusMessage_JCA0._1208_LEVEL, JeusMessage_JCA0._1208);
        }
        return jcaf.getConnectionPool().getManagedConnectionFactory();
    }

    public static ManagedConnectionFactory createManagedConnectionFactory(String mcfClassName, ClassLoader loader, List properties) throws Exception {
        Class<?> clazz = loader.loadClass(mcfClassName);
        ManagedConnectionFactory managedFactory = (ManagedConnectionFactory)clazz.newInstance();
        for (Object obj : properties) {
            ConfigPropertyType property;
            Class[] argTypes = null;
            Object[] args = null;
            String propName = null;
            if (obj instanceof ConfigPropertyType) {
                property = (ConfigPropertyType)obj;
                argTypes = new Class[]{ConnectorUtility.getPropertyType(property.getConfigPropertyType().getValue())};
                if (property.getConfigPropertyValue() == null) continue;
                args = new Object[]{ConnectorUtility.getPropertyValue(argTypes[0], property.getConfigPropertyValue().getValue())};
                propName = property.getConfigPropertyName().getValue();
                propName = propName.substring(0, 1).toUpperCase() + propName.substring(1);
            } else if (obj instanceof ConnectorPropertyType) {
                property = (ConnectorPropertyType)obj;
                argTypes = new Class[]{ConnectorUtility.getPropertyType(property.getType())};
                args = new Object[]{ConnectorUtility.getPropertyValue(argTypes[0], property.getValue())};
                propName = property.getName();
                propName = propName.substring(0, 1).toUpperCase() + propName.substring(1);
            }
            try {
                ConnectorUtility.invokeMethod(clazz, "set" + propName, argTypes, managedFactory, args);
            }
            catch (ResourceException ex1) {
                argTypes[0] = ConnectorUtility.getWrapperClass((Class)argTypes[0]);
                ConnectorUtility.invokeMethod(clazz, "set" + propName, argTypes, managedFactory, args);
            }
        }
        return managedFactory;
    }
}

