/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.util.Set;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LazyEnlistableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import jeus.connector.ConnectorLocalDemarcator;
import jeus.connector.ManagedConnectionPool;
import jeus.connector.ManagedConnectionTxState;
import jeus.transaction.TransactionImpl;
import jeus.util.ObjectBaseHashMap;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA1;

public class ManagedConnectionState {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");
    private static final int NEW = 0;
    private static final int ACTIVE = 1;
    private static final int POOLED = 2;
    private static final int DESTROYED = 3;
    private int state;
    final ManagedConnectionPool mcp;
    final ManagedConnection manCon;
    private final boolean useWrapper;
    final ConnectionRequestInfo reqInfo;
    final Subject subject;
    private boolean disposable;
    private final boolean dissociatable;
    private final boolean lazyEnlistable;
    final int txSupport;
    XAResource xaResource;
    ConnectorLocalDemarcator localDemarcator;
    ConnectionEventListener listener;
    TransactionImpl enlistedTx;
    final ObjectBaseHashMap sharedHandles;
    private long accessTime = 0L;
    private long activatedTime = 0L;
    private long pooledTime = -1L;
    private final long creationTime;
    public int index = -1;
    public static final int NoTransaction = 0;
    public static final int LocalTransaction = 1;
    public static final int XATransaction = 2;
    public static final int XATransactionOnly = 3;
    private boolean shareable;
    ManagedConnectionTxState txState;

    ManagedConnectionState(ManagedConnectionPool mcp, ManagedConnection manCon, boolean disposable, ConnectionRequestInfo reqInfo, Subject subject) {
        this.mcp = mcp;
        this.manCon = manCon;
        this.txSupport = mcp.getPoolInfo().getTxType();
        this.disposable = disposable;
        this.reqInfo = reqInfo;
        this.subject = subject;
        this.useWrapper = mcp.getPoolInfo().isUseWrapper();
        Class<?> clazz = manCon.getClass();
        this.dissociatable = DissociatableManagedConnection.class.isAssignableFrom(clazz);
        this.lazyEnlistable = LazyEnlistableManagedConnection.class.isAssignableFrom(clazz);
        this.sharedHandles = new ObjectBaseHashMap();
        this.activatedTime = this.creationTime = System.currentTimeMillis();
        this.accessTime = this.creationTime;
        this.setState(0);
    }

    public final int hashCode() {
        return this.manCon.hashCode();
    }

    public final boolean equals(Object obj) {
        return this.manCon.equals(obj);
    }

    public final ConnectionRequestInfo getResuestInfo() {
        return this.reqInfo;
    }

    private boolean equalRequestInfo(ConnectionRequestInfo another) {
        if (this.reqInfo == null) {
            return another == null;
        }
        return this.reqInfo.equals(another);
    }

    private boolean equalSubject(Subject other) {
        if (this.subject == null && other == null) {
            return true;
        }
        if (this.subject != null && other != null) {
            return this.checkPrivateCredentials(other.getPrivateCredentials()) && this.checkPublicCredentials(other.getPublicCredentials());
        }
        return false;
    }

    private boolean checkPublicCredentials(Set otherCredentials) {
        Set<Object> thisCredentials = this.subject.getPublicCredentials();
        if (thisCredentials != otherCredentials && thisCredentials != null) {
            return ((Object)thisCredentials).equals(otherCredentials);
        }
        return false;
    }

    private boolean checkPrivateCredentials(Set otherCredentials) {
        Set<Object> thisCredentials = this.subject.getPrivateCredentials();
        if (thisCredentials != otherCredentials && thisCredentials != null) {
            return ((Object)thisCredentials).equals(otherCredentials);
        }
        return false;
    }

    public final void setDisposable(boolean disposable) {
        this.disposable = disposable;
    }

    public final boolean isLazyAssociatable() {
        if (this.isDestroyed()) {
            return false;
        }
        return this.manCon instanceof LazyEnlistableManagedConnection;
    }

    public final ManagedConnection getRealConnection() {
        return this.manCon;
    }

    public final long getPooledTime() {
        return this.pooledTime;
    }

    public final void setPooled() {
        this.setState(2);
        this.pooledTime = System.currentTimeMillis();
        this.mcp.getPoolStats().getUseTime().addData(this.pooledTime - this.activatedTime);
    }

    public final void setActivated() {
        this.setState(1);
        this.accessTime = this.activatedTime = System.currentTimeMillis();
    }

    public final long getActivatedTime() {
        return this.activatedTime;
    }

    public final boolean inUse() {
        return this.activatedTime > this.pooledTime;
    }

    public final boolean isDisposable() {
        return this.disposable;
    }

    private boolean isShareable() {
        return this.shareable;
    }

    public final void setShareable(boolean shareable) {
        this.shareable = shareable;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final int getState() {
        return this.state;
    }

    private void setState(int state) {
        this.state = state;
    }

    public final boolean isDestroyed() {
        return this.state == 3;
    }

    final void setDestroyed() {
        this.setState(3);
    }

    public final String getIdentity() {
        return "[" + this.manCon.hashCode() + "/" + this.index + "]";
    }

    private long getAccessTime() {
        return this.accessTime;
    }

    final void setAccessed() {
        this.accessTime = System.currentTimeMillis();
    }

    final boolean isUseWrapper() {
        return this.useWrapper;
    }

    final boolean isLazyEnlistable() {
        return this.lazyEnlistable;
    }

    private boolean isDissociatable() {
        return this.dissociatable;
    }

    final void changeTxState(ManagedConnectionTxState newState) {
        this.txState = newState;
    }

    private boolean isShareableNow() {
        return this.isShareable() && !this.isDestroyed() && !this.isDisposable() && !this.txState.isCci();
    }

    public final boolean isDissociatableNow() {
        boolean dissociatable;
        if (logger.isLoggable(JeusMessage_JCA1._1751_LEVEL)) {
            logger.log(JeusMessage_JCA1._1751_LEVEL, JeusMessage_JCA1._1751, (Object)this.getIdentity());
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("check isDissociatable!!");
        }
        if (!this.isDissociatable() || this.txState.isTransacted()) {
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("dissociatable ? " + this.isDissociatable() + " " + this.txState.getClass().getName());
            }
            if (logger.isLoggable(JeusMessage_JCA1._1752_LEVEL)) {
                logger.log(JeusMessage_JCA1._1752_LEVEL, JeusMessage_JCA1._1752, (Object)this.getIdentity());
            }
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("*** currentTime - accessTime : " + (currentTime - this.getAccessTime()));
        }
        boolean bl = dissociatable = currentTime - this.getAccessTime() > this.mcp.getPoolInfo().getPooledTimeout();
        if (logger.isLoggable(JeusMessage_JCA1._1753_LEVEL)) {
            logger.log(JeusMessage_JCA1._1753_LEVEL, JeusMessage_JCA1._1753, new Object[]{this.getIdentity(), dissociatable ? "" : "not "});
        }
        return dissociatable;
    }

    public final boolean isInvalidatableNow() {
        boolean invalidatable;
        if (logger.isLoggable(JeusMessage_JCA1._1754_LEVEL)) {
            logger.log(JeusMessage_JCA1._1754_LEVEL, JeusMessage_JCA1._1754, (Object)this.getIdentity());
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("check isInvalidatable !!");
        }
        if (this.txState.isTransacted()) {
            if (logger.isLoggable(JeusMessage_JCA1._1755_LEVEL)) {
                logger.log(JeusMessage_JCA1._1755_LEVEL, JeusMessage_JCA1._1755, (Object)this.getIdentity());
            }
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("*** currentTime - accessTime : " + (currentTime - this.getAccessTime()));
        }
        boolean bl = invalidatable = currentTime - this.getAccessTime() > this.mcp.getPoolInfo().getInvalidationTimeout();
        if (logger.isLoggable(JeusMessage_JCA1._1756_LEVEL)) {
            logger.log(JeusMessage_JCA1._1756_LEVEL, JeusMessage_JCA1._1756, new Object[]{this.getIdentity(), invalidatable ? "" : "not "});
        }
        return invalidatable;
    }

    final boolean canShareTransaction(ManagedConnectionState target) {
        if (logger.isLoggable(JeusMessage_JCA1._1757_LEVEL)) {
            logger.log(JeusMessage_JCA1._1757_LEVEL, JeusMessage_JCA1._1757, new Object[]{this.getIdentity(), target.getIdentity()});
        }
        if (target == null || !this.isShareableNow() || !target.isShareableNow()) {
            if (logger.isLoggable(JeusMessage_JCA1._1758_LEVEL)) {
                logger.log(JeusMessage_JCA1._1758_LEVEL, JeusMessage_JCA1._1758, new Object[]{this.getIdentity(), target.getIdentity(), "not "});
            }
            return false;
        }
        return this.canShareTransaction(target.reqInfo, target.subject);
    }

    public final boolean canShareTransaction(ConnectionRequestInfo info, Subject sub) {
        boolean compareContext;
        if (logger.isLoggable(JeusMessage_JCA1._1759_LEVEL)) {
            logger.log(JeusMessage_JCA1._1759_LEVEL, JeusMessage_JCA1._1759, new Object[]{this.getIdentity(), info, sub});
        }
        boolean bl = compareContext = this.isShareableNow() && this.equalRequestInfo(info) && this.equalSubject(sub);
        if (logger.isLoggable(JeusMessage_JCA1._1760_LEVEL)) {
            logger.log(JeusMessage_JCA1._1760_LEVEL, JeusMessage_JCA1._1760, new Object[]{this.getIdentity(), compareContext ? "" : "not ", info, sub});
        }
        return compareContext;
    }
}

