/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import javax.resource.ResourceException;
import javax.resource.spi.SharingViolationException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import jeus.connector.ManagedConnectionHandler;
import jeus.transaction.TMService;
import jeus.transaction.TransactionImpl;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA0;
import jeus.util.message.JeusMessage_JCA1;

abstract class ManagedConnectionTxState {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");
    final ManagedConnectionHandler mch;

    static ManagedConnectionTxState getInitialState(ManagedConnectionHandler mch) {
        return new NoTxState(mch);
    }

    private ManagedConnectionTxState(ManagedConnectionHandler mch) {
        this.mch = mch;
    }

    abstract void rollbackLocalTx();

    abstract void cciLocalTransactionStarted();

    abstract void cciLocalTransactionCompleted();

    abstract void spiLocalTransactionStarted(Xid var1);

    abstract void spiLocalTransactionCompleted();

    abstract void spiGlobalTransactionStarted(Xid var1);

    abstract void globalTransactionCompleted();

    abstract void rollbackLocalTxForced();

    abstract void rollbackGlobalTxForced();

    abstract void clear();

    abstract boolean lazyEnlist() throws ResourceException;

    abstract void checkStatus(Object var1) throws ResourceException;

    abstract boolean isTransacted();

    abstract boolean isCci();

    private static final class SpiGlobalTxState
    extends ManagedConnectionTxState {
        private SpiGlobalTxState(ManagedConnectionHandler managedConnectionHandler) {
            super(managedConnectionHandler);
        }

        final void cciLocalTransactionStarted() {
            TMService.enlistLocalTransaction(this.mch);
            this.mch.changeTxState(new CciLocalTxState(this.mch));
            this.mch.arrangeSpiTxRollback();
        }

        final void globalTransactionCompleted() {
            if (logger.isLoggable(JeusMessage_JCA0._1463_LEVEL)) {
                logger.log(JeusMessage_JCA0._1463_LEVEL, JeusMessage_JCA0._1463);
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("spi global transaction is completed ");
            }
            this.mch.changeTxState(new NoTxState(this.mch));
            this.mch.enlistedTx = null;
            this.mch.clear();
        }

        final void rollbackGlobalTxForced() {
            block3: {
                try {
                    TransactionImpl curTx = ManagedConnectionHandler.getTransaction();
                    if (curTx != null) {
                        curTx.rollback();
                    }
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_JCA0._1422_LEVEL)) break block3;
                    logger.log(JeusMessage_JCA0._1422_LEVEL, JeusMessage_JCA0._1422, t);
                }
            }
        }

        final void clear() {
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("not pooled for... " + this.getClass().getName() + ":" + this.mch.sharedHandles.size() + ":" + this.mch.isDestroyed());
            }
            if (logger.isLoggable(JeusMessage_JCA0._1479_LEVEL)) {
                logger.log(JeusMessage_JCA0._1479_LEVEL, JeusMessage_JCA0._1479);
            }
        }

        final boolean lazyEnlist() throws ResourceException {
            return this.mch.spiLazyEnlist();
        }

        final void checkStatus(Object handle) throws ResourceException {
            this.mch.checkCurrentTransaction(handle);
        }

        final void rollbackLocalTx() {
        }

        final void cciLocalTransactionCompleted() {
        }

        final void spiLocalTransactionStarted(Xid xid) {
        }

        final void spiLocalTransactionCompleted() {
        }

        final void spiGlobalTransactionStarted(Xid xid) {
        }

        final void rollbackLocalTxForced() {
        }

        final boolean isTransacted() {
            return true;
        }

        final boolean isCci() {
            return false;
        }
    }

    private static final class SpiLocalTxState
    extends ManagedConnectionTxState {
        private SpiLocalTxState(ManagedConnectionHandler managedConnectionHandler) {
            super(managedConnectionHandler);
        }

        final void cciLocalTransactionStarted() {
            TMService.enlistLocalTransaction(this.mch);
            this.mch.changeTxState(new CciLocalTxState(this.mch));
            this.mch.arrangeSpiTxRollback();
        }

        final void spiLocalTransactionCompleted() {
            if (logger.isLoggable(JeusMessage_JCA0._1461_LEVEL)) {
                logger.log(JeusMessage_JCA0._1461_LEVEL, JeusMessage_JCA0._1461);
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("spi local transaction is completed ");
            }
            this.mch.changeTxState(new NoTxState(this.mch));
            this.mch.enlistedTx = null;
            this.mch.clear();
        }

        final void rollbackLocalTxForced() {
            block2: {
                try {
                    this.mch.manCon.getLocalTransaction().rollback();
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_JCA0._1476_LEVEL)) break block2;
                    logger.log(JeusMessage_JCA0._1476_LEVEL, JeusMessage_JCA0._1476, t);
                }
            }
        }

        final void clear() {
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("not pooled for... " + this.getClass().getName() + ":" + this.mch.sharedHandles.size() + ":" + this.mch.isDestroyed());
            }
            if (logger.isLoggable(JeusMessage_JCA0._1479_LEVEL)) {
                logger.log(JeusMessage_JCA0._1479_LEVEL, JeusMessage_JCA0._1479);
            }
        }

        final boolean lazyEnlist() throws ResourceException {
            return this.mch.spiLazyEnlist();
        }

        final void checkStatus(Object handle) throws ResourceException {
            this.mch.checkCurrentTransaction(handle);
        }

        final void rollbackLocalTx() {
        }

        final void cciLocalTransactionCompleted() {
        }

        final void spiLocalTransactionStarted(Xid xid) {
        }

        final void spiGlobalTransactionStarted(Xid xid) {
        }

        final void globalTransactionCompleted() {
        }

        final void rollbackGlobalTxForced() {
        }

        final boolean isTransacted() {
            return true;
        }

        final boolean isCci() {
            return false;
        }
    }

    private static final class CciLocalTxState
    extends ManagedConnectionTxState {
        private CciLocalTxState(ManagedConnectionHandler managedConnectionHandler) {
            super(managedConnectionHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void rollbackLocalTx() {
            if (logger.isLoggable(JeusMessage_JCA0._1454_LEVEL)) {
                logger.log(JeusMessage_JCA0._1454_LEVEL, JeusMessage_JCA0._1454);
            }
            try {
                this.mch.manCon.getLocalTransaction().rollback();
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_JCA0._1455_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1455_LEVEL, JeusMessage_JCA0._1455, t);
                }
            }
            finally {
                this.mch.changeTxState(new NoTxState(this.mch));
                this.mch.destroy();
            }
        }

        final void cciLocalTransactionCompleted() {
            if (logger.isLoggable(JeusMessage_JCA0._1459_LEVEL)) {
                logger.log(JeusMessage_JCA0._1459_LEVEL, JeusMessage_JCA0._1459);
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("cci local transaction is completed ");
            }
            this.mch.changeTxState(new NoTxState(this.mch));
            this.mch.clear();
        }

        final void rollbackLocalTxForced() {
            block2: {
                try {
                    this.mch.manCon.getLocalTransaction().rollback();
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_JCA0._1476_LEVEL)) break block2;
                    logger.log(JeusMessage_JCA0._1476_LEVEL, JeusMessage_JCA0._1476, t);
                }
            }
        }

        final void clear() {
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("not pooled for... " + this.getClass().getName() + ":" + this.mch.sharedHandles.size() + ":" + this.mch.isDestroyed());
            }
            if (logger.isLoggable(JeusMessage_JCA0._1479_LEVEL)) {
                logger.log(JeusMessage_JCA0._1479_LEVEL, JeusMessage_JCA0._1479);
            }
        }

        final boolean lazyEnlist() throws ResourceException {
            if (logger.isLoggable(JeusMessage_JCA1._1522_LEVEL)) {
                logger.log(JeusMessage_JCA1._1522_LEVEL, JeusMessage_JCA1._1522, (Object)this.mch.getIdentity());
            }
            throw new SharingViolationException();
        }

        final void checkStatus(Object handle) {
            if (logger.isLoggable(JeusMessage_JCA0._1487_LEVEL)) {
                logger.log(JeusMessage_JCA0._1487_LEVEL, JeusMessage_JCA0._1487, (Object)this.mch.getIdentity());
            }
        }

        final void cciLocalTransactionStarted() {
        }

        final void spiLocalTransactionStarted(Xid xid) {
        }

        final void spiLocalTransactionCompleted() {
        }

        final void spiGlobalTransactionStarted(Xid xid) {
        }

        final void globalTransactionCompleted() {
        }

        final void rollbackGlobalTxForced() {
        }

        final boolean isTransacted() {
            return true;
        }

        final boolean isCci() {
            return true;
        }
    }

    private static final class NoTxState
    extends ManagedConnectionTxState {
        private NoTxState(ManagedConnectionHandler managedConnectionHandler) {
            super(managedConnectionHandler);
        }

        final void cciLocalTransactionStarted() {
            TMService.enlistLocalTransaction(this.mch);
            this.mch.changeTxState(new CciLocalTxState(this.mch));
        }

        final void spiLocalTransactionStarted(Xid xid) {
            if (logger.isLoggable(JeusMessage_JCA0._1460_LEVEL)) {
                logger.log(JeusMessage_JCA0._1460_LEVEL, JeusMessage_JCA0._1460);
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("spi local transaction is started " + xid);
            }
            this.mch.changeTxState(new SpiLocalTxState(this.mch));
        }

        final void spiGlobalTransactionStarted(Xid xid) {
            TransactionImpl curTx;
            if (logger.isLoggable(JeusMessage_JCA0._1462_LEVEL)) {
                logger.log(JeusMessage_JCA0._1462_LEVEL, JeusMessage_JCA0._1462);
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("spi global transaction is started " + xid);
            }
            if ((curTx = ManagedConnectionHandler.getTransaction()) != null) {
                try {
                    curTx.registerSynchronization(new Synchronization(){

                        public void beforeCompletion() {
                        }

                        public void afterCompletion(int status) {
                            NoTxState.this.mch.globalTransactionCompleted();
                        }
                    });
                }
                catch (RollbackException e) {
                }
                catch (SystemException systemException) {
                    // empty catch block
                }
            }
            this.mch.changeTxState(new SpiGlobalTxState(this.mch));
        }

        final void clear() {
            if (this.mch.sharedHandles.size() != 0 || this.mch.isDestroyed()) {
                if (logger.isLoggable(JeusLevel.DEV)) {
                    logger.dev("not pooled for... " + this.getClass().getName() + ":" + this.mch.sharedHandles.size() + ":" + this.mch.isDestroyed());
                }
                if (logger.isLoggable(JeusMessage_JCA0._1479_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1479_LEVEL, JeusMessage_JCA0._1479);
                }
                return;
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("---[NAVIS/ManagedConnectionHandler/clear] isDisposable : " + this.mch.isDisposable() + " from : " + this.mch.manCon.hashCode());
            }
            if (this.mch.isDisposable()) {
                if (logger.isLoggable(JeusMessage_JCA0._1480_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1480_LEVEL, JeusMessage_JCA0._1480);
                }
                this.mch.destroy();
            } else {
                try {
                    if (logger.isLoggable(JeusMessage_JCA0._1481_LEVEL)) {
                        logger.log(JeusMessage_JCA0._1481_LEVEL, JeusMessage_JCA0._1481);
                    }
                    this.mch.manCon.removeConnectionEventListener(this.mch.listener);
                    this.mch.manCon.cleanup();
                    if (logger.isLoggable(JeusMessage_JCA0._1482_LEVEL)) {
                        logger.log(JeusMessage_JCA0._1482_LEVEL, JeusMessage_JCA0._1482);
                    }
                    this.mch.mcp.returnConnection(this.mch);
                }
                catch (Throwable t) {
                    if (logger.isLoggable(JeusMessage_JCA0._1483_LEVEL)) {
                        logger.log(JeusMessage_JCA0._1483_LEVEL, JeusMessage_JCA0._1483);
                    }
                    t.printStackTrace();
                    this.mch.destroy();
                }
            }
        }

        final void checkStatus(Object handle) throws ResourceException {
            this.mch.checkCurrentTransaction(handle);
        }

        final void rollbackLocalTx() {
        }

        final void cciLocalTransactionCompleted() {
        }

        final void spiLocalTransactionCompleted() {
        }

        final void globalTransactionCompleted() {
        }

        final void rollbackLocalTxForced() {
        }

        final void rollbackGlobalTxForced() {
        }

        final boolean lazyEnlist() {
            return false;
        }

        final boolean isTransacted() {
            return false;
        }

        final boolean isCci() {
            return false;
        }
    }
}

