/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector.work;

import javax.management.j2ee.statistics.Statistic;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import jeus.connector.work.WorkExecutor;
import jeus.connector.work.WorkQueue;
import jeus.connector.work.WorkWrapper;
import jeus.management.j2ee.statistics.BoundedRangeStatisticImpl;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.management.j2ee.statistics.JCAWorkManagerStatsImpl;
import jeus.management.j2ee.statistics.RangeStatisticImpl;
import jeus.management.j2ee.statistics.TimeStatisticImpl;
import jeus.transaction.ConnectorXATerminator;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA1;
import jeus.xml.binding.connectorHelper.WorkerPoolDescriptor;
import jeus.xml.binding.jeusDD.WorkerPoolType;

public class WorkManager
implements javax.resource.spi.work.WorkManager {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");
    private ConnectorXATerminator xaResource;
    private WorkExecutor workerExecutor;
    private WorkQueue msgPool;
    private int max;
    private int min;
    private int step;
    private long keepAliveTime;
    private long releaseTimeout;
    private long rejectTimeout;
    private long shutdownTimeout;
    private boolean warmup;
    protected boolean running;
    protected TimeStatisticImpl acceptTime;
    protected TimeStatisticImpl rejectTime;
    protected TimeStatisticImpl startTime;
    protected TimeStatisticImpl completeTime;
    protected TimeStatisticImpl useTime;
    protected CountStatisticImpl createCount;
    protected CountStatisticImpl shrinkCount;
    protected CountStatisticImpl acquireFailCount;
    protected BoundedRangeStatisticImpl freeThreads;
    protected BoundedRangeStatisticImpl pooledThreads;
    protected RangeStatisticImpl waitingThreadCount;
    protected JCAWorkManagerStatsImpl workStats;

    public WorkManager(WorkerPoolDescriptor inbound) {
        logger.log(JeusMessage_JCA1._1901_LEVEL, JeusMessage_JCA1._1901);
        this.xaResource = ConnectorXATerminator.getXATerminatorImpl();
        this.msgPool = new WorkQueue(4096, true);
        WorkerPoolType desc = inbound.getThreadPoolType();
        this.min = desc.getMin();
        this.max = desc.getMax();
        this.step = desc.getStep();
        this.warmup = desc.isPreAllocation();
        this.keepAliveTime = desc.getPooledTimeout();
        this.releaseTimeout = desc.getReleaseTimeout();
        this.rejectTimeout = desc.getSubmitTimeout();
        this.shutdownTimeout = desc.getShutdownTimeout();
        logger.log(JeusMessage_JCA1._1902_LEVEL, JeusMessage_JCA1._1902, (Object)this);
    }

    public void init(JCAWorkManagerStatsImpl workStats) {
        logger.log(JeusMessage_JCA1._1903_LEVEL, JeusMessage_JCA1._1903);
        this.workStats = workStats;
        this.acceptTime = new TimeStatisticImpl("AcceptTime", "millisecond", "the time spent waiting for accepting requested work");
        this.rejectTime = new TimeStatisticImpl("RejectTime", "millisecond", "the time interval from request issued to work rejected");
        this.startTime = new TimeStatisticImpl("StartTime", "millisecond", "the time spent waiting for starting requested work");
        this.completeTime = new TimeStatisticImpl("CompleteTime", "millisecond", "the time spent for completing requested work");
        this.useTime = new TimeStatisticImpl("UseTime", "millisecond", "the time spent using a worker");
        this.createCount = new CountStatisticImpl("CreateCount", "workers", "the number of created workers");
        this.shrinkCount = new CountStatisticImpl("ShrinkCount", "workers", "the number of shrinked workers by pooled timeout");
        this.acquireFailCount = new CountStatisticImpl("AcquireFailCount", "count", "the number of failure of acquirng worker");
        this.freeThreads = new BoundedRangeStatisticImpl("FreeThreads", "workers", "the number of free workers in the pool", (long)this.max, 0L);
        this.pooledThreads = new BoundedRangeStatisticImpl("PooledThreads", "workers", "the size of the worker pool", (long)this.max, 0L);
        this.waitingThreadCount = new RangeStatisticImpl("WaitingThreadCount", "workers", "the number of threads waiting for a worker");
        this.freeThreads.set(0L);
        this.pooledThreads.set(0L);
        workStats.setStatistic((Statistic)this.acceptTime);
        workStats.setStatistic((Statistic)this.rejectTime);
        workStats.setStatistic((Statistic)this.startTime);
        workStats.setStatistic((Statistic)this.completeTime);
        workStats.setStatistic((Statistic)this.useTime);
        workStats.setStatistic((Statistic)this.createCount);
        workStats.setStatistic((Statistic)this.shrinkCount);
        workStats.setStatistic((Statistic)this.acquireFailCount);
        workStats.setStatistic((Statistic)this.waitingThreadCount);
        workStats.setStatistic((Statistic)this.pooledThreads);
        workStats.setStatistic((Statistic)this.freeThreads);
        logger.log(JeusMessage_JCA1._1904_LEVEL, JeusMessage_JCA1._1904);
        this.workerExecutor = new WorkExecutor(this, this.msgPool, this.max, this.step, this.freeThreads, this.pooledThreads);
        this.workerExecutor.setMinimumPoolSize(this.min);
        this.workerExecutor.setKeepAliveTime(this.keepAliveTime);
        if (this.warmup) {
            if (logger.isLoggable(JeusMessage_JCA1._1905_LEVEL)) {
                logger.log(JeusMessage_JCA1._1905_LEVEL, JeusMessage_JCA1._1905, (Object)String.valueOf(this.min));
            }
            this.workerExecutor.createThreads(this.min);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.running = true;
        logger.log(JeusMessage_JCA1._1906_LEVEL, JeusMessage_JCA1._1906, (Object)this);
    }

    public void init() {
        this.acceptTime = new TimeStatisticImpl("AcceptTime", "millisecond", "the time spent waiting for accepting requested work");
        this.rejectTime = new TimeStatisticImpl("RejectTime", "millisecond", "the time interval from request issued to work rejected");
        this.startTime = new TimeStatisticImpl("StartTime", "millisecond", "the time spent waiting for starting requested work");
        this.completeTime = new TimeStatisticImpl("CompleteTime", "millisecond", "the time spent for completing requested work");
        this.useTime = new TimeStatisticImpl("UseTime", "millisecond", "the time spent using a worker");
        this.createCount = new CountStatisticImpl("CreateCount", "workers", "the number of created workers");
        this.shrinkCount = new CountStatisticImpl("ShrinkCount", "workers", "the number of shrinked workers by pooled timeout");
        this.acquireFailCount = new CountStatisticImpl("AcquireFailCount", "count", "the number of failure of acquirng worker");
        this.freeThreads = new BoundedRangeStatisticImpl("FreeThreads", "workers", "the number of free workers in the pool", (long)this.max, 0L);
        this.pooledThreads = new BoundedRangeStatisticImpl("PooledThreads", "workers", "the size of the worker pool", (long)this.max, 0L);
        this.waitingThreadCount = new RangeStatisticImpl("WaitingThreadCount", "workers", "the number of threads waiting for a worker");
        this.freeThreads.set(0L);
        this.pooledThreads.set(0L);
        this.workerExecutor = new WorkExecutor(this, this.msgPool, this.max, this.step, this.freeThreads, this.pooledThreads);
        this.workerExecutor.setMinimumPoolSize(this.min);
        this.workerExecutor.setKeepAliveTime(this.keepAliveTime);
        if (this.warmup) {
            this.workerExecutor.createThreads(5);
        }
        this.running = true;
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev(this.toString());
        }
    }

    public void doWork(Work work) throws WorkException {
        if (logger.isLoggable(JeusMessage_JCA1._1907_LEVEL)) {
            logger.log(JeusMessage_JCA1._1907_LEVEL, JeusMessage_JCA1._1907, (Object)work);
        }
        this.doWork(work, 0L, null, null);
        if (logger.isLoggable(JeusMessage_JCA1._1908_LEVEL)) {
            logger.log(JeusMessage_JCA1._1908_LEVEL, JeusMessage_JCA1._1908);
        }
    }

    public void doWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener lsnr) throws WorkException {
        if (logger.isLoggable(JeusMessage_JCA1._1909_LEVEL)) {
            logger.log(JeusMessage_JCA1._1909_LEVEL, JeusMessage_JCA1._1909, new Object[]{work, String.valueOf(startTimeout)});
        }
        WorkWrapper state = this.addWork(work, startTimeout, ctx, lsnr);
        state.waitState(4);
        if (logger.isLoggable(JeusMessage_JCA1._1910_LEVEL)) {
            logger.log(JeusMessage_JCA1._1910_LEVEL, JeusMessage_JCA1._1910);
        }
    }

    public long startWork(Work work) throws WorkException {
        if (logger.isLoggable(JeusMessage_JCA1._1911_LEVEL)) {
            logger.log(JeusMessage_JCA1._1911_LEVEL, JeusMessage_JCA1._1911, (Object)work);
        }
        long startTime = this.startWork(work, 0L, null, null);
        if (logger.isLoggable(JeusMessage_JCA1._1912_LEVEL)) {
            logger.log(JeusMessage_JCA1._1912_LEVEL, JeusMessage_JCA1._1912, (Object)String.valueOf(startTime));
        }
        return startTime;
    }

    public long startWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener lsnr) throws WorkException {
        if (logger.isLoggable(JeusMessage_JCA1._1913_LEVEL)) {
            logger.log(JeusMessage_JCA1._1913_LEVEL, JeusMessage_JCA1._1913, new Object[]{work, String.valueOf(startTimeout)});
        }
        WorkWrapper state = this.addWork(work, startTimeout, ctx, lsnr);
        state.waitState(3);
        long startTime = state.getStartElapsed();
        if (logger.isLoggable(JeusMessage_JCA1._1914_LEVEL)) {
            logger.log(JeusMessage_JCA1._1914_LEVEL, JeusMessage_JCA1._1914, (Object)String.valueOf(startTime));
        }
        return startTime;
    }

    public void scheduleWork(Work work) throws WorkException {
        if (logger.isLoggable(JeusMessage_JCA1._1915_LEVEL)) {
            logger.log(JeusMessage_JCA1._1915_LEVEL, JeusMessage_JCA1._1915, (Object)work);
        }
        this.scheduleWork(work, 0L, null, null);
        if (logger.isLoggable(JeusMessage_JCA1._1916_LEVEL)) {
            logger.log(JeusMessage_JCA1._1916_LEVEL, JeusMessage_JCA1._1916);
        }
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener lsnr) throws WorkException {
        if (logger.isLoggable(JeusMessage_JCA1._1917_LEVEL)) {
            logger.log(JeusMessage_JCA1._1917_LEVEL, JeusMessage_JCA1._1917, new Object[]{work, String.valueOf(startTimeout)});
        }
        WorkWrapper state = this.addWork(work, startTimeout, ctx, lsnr);
        state.waitState(1);
        if (logger.isLoggable(JeusMessage_JCA1._1918_LEVEL)) {
            logger.log(JeusMessage_JCA1._1918_LEVEL, JeusMessage_JCA1._1918);
        }
    }

    private WorkWrapper addWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener lsnr) throws WorkException {
        if (!this.running) {
            if (logger.isLoggable(JeusMessage_JCA1._1919_LEVEL)) {
                logger.log(JeusMessage_JCA1._1919_LEVEL, JeusMessage_JCA1._1919);
            }
            throw new WorkRejectedException("Work Manager is not runnning");
        }
        if (startTimeout < 0L) {
            startTimeout = 0L;
        }
        WorkWrapper state = new WorkWrapper(this, this.xaResource, work, startTimeout, this.releaseTimeout, ctx, lsnr);
        this.workerExecutor.execute(state, this.rejectTimeout);
        return state;
    }

    public ConnectorXATerminator getXaResource() {
        if (logger.isLoggable(JeusMessage_JCA1._1920_LEVEL)) {
            logger.log(JeusMessage_JCA1._1920_LEVEL, JeusMessage_JCA1._1920);
        }
        return this.xaResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (logger.isLoggable(JeusMessage_JCA1._1921_LEVEL)) {
            logger.log(JeusMessage_JCA1._1921_LEVEL, JeusMessage_JCA1._1921, (Object)String.valueOf(this.shutdownTimeout));
        }
        this.running = false;
        boolean shutdowned = this.workerExecutor.shutdown();
        if (!shutdowned) {
            try {
                if (logger.isLoggable(JeusMessage_JCA1._1922_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1922_LEVEL, JeusMessage_JCA1._1922);
                }
                shutdowned = this.workerExecutor.awaitTerminationAfterShutdown(this.shutdownTimeout);
            }
            catch (Throwable throwable) {
            }
            finally {
                if (!shutdowned) {
                    if (logger.isLoggable(JeusMessage_JCA1._1923_LEVEL)) {
                        logger.log(JeusMessage_JCA1._1923_LEVEL, JeusMessage_JCA1._1923);
                    }
                    this.workerExecutor.interruptAll();
                }
            }
        }
        if (logger.isLoggable(JeusMessage_JCA1._1924_LEVEL)) {
            logger.log(JeusMessage_JCA1._1924_LEVEL, JeusMessage_JCA1._1924);
        }
    }

    public String toString() {
        return "WorkManager{max=" + this.max + ", min=" + this.min + ", step=" + this.step + ", keepAliveTime=" + this.keepAliveTime + ", releaseTimeout=" + this.releaseTimeout + ", rejectTimeout=" + this.rejectTimeout + ", warmup=" + this.warmup + "}";
    }

    public JCAWorkManagerStatsImpl getWorkStats() {
        return this.workStats;
    }

    public void setMin(int min) throws Exception {
        this.workerExecutor.setMinimumPoolSize(min);
        this.min = min;
    }

    public void setMax(int max) throws Exception {
        this.workerExecutor.setMinimumPoolSize(max);
        this.max = max;
    }

    public void setStep(int step) throws Exception {
        this.workerExecutor.setIncreaseStepSize(step);
        this.step = step;
    }

    public void setKeepAliveTime(long time) throws Exception {
        this.workerExecutor.setKeepAliveTime(time);
        this.keepAliveTime = time;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public int getStep() {
        return this.step;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public long getReleaseTimeout() {
        return this.releaseTimeout;
    }

    public void setReleaseTimeout(long releaseTimeout) {
        this.releaseTimeout = releaseTimeout;
    }

    public long getRejectTimeout() {
        return this.rejectTimeout;
    }

    public void setRejectTimeout(long rejectTimeout) {
        this.rejectTimeout = rejectTimeout;
    }
}

