/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jeus.container.annotation.AnnotationProcessor;
import jeus.deploy.InvalidAnnotationException;
import jeus.util.ClassUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Client;

public class ClassAnnotationReader {
    private static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
    private Class cls;
    private List<AnnotationProcessor> processors;
    private boolean staticMemberOnly;

    public ClassAnnotationReader(Class clazz) {
        this.cls = clazz;
        this.processors = new ArrayList<AnnotationProcessor>();
    }

    public void setStaticMemberOnly(boolean flag) {
        this.staticMemberOnly = flag;
    }

    public void addAnnotationProcessor(AnnotationProcessor processor) {
        this.processors.add(processor);
    }

    public void process() throws InvalidAnnotationException {
        try {
            for (AnnotationProcessor proc : this.processors) {
                proc.processClass(this.cls);
            }
            Field[] fields = this.staticMemberOnly ? ClassUtil.getAllStaticFields(this.cls, Object.class) : ClassUtil.getAllDeclaredFields(this.cls, Object.class);
            for (Field field : fields) {
                for (AnnotationProcessor proc : this.processors) {
                    proc.processField(field);
                }
            }
            List constructors = Collections.EMPTY_LIST;
            for (Constructor constructor : constructors) {
                for (AnnotationProcessor proc : this.processors) {
                    proc.processConstructor(constructor);
                }
            }
            List<Method> methods = this.staticMemberOnly ? ClassUtil.getAllStaticMethods(this.cls, Object.class) : ClassUtil.getAllMethods(this.cls, Object.class);
            for (Method method : methods) {
                for (AnnotationProcessor proc : this.processors) {
                    proc.processMethod(method);
                }
            }
            for (AnnotationProcessor proc : this.processors) {
                proc.processFinished();
            }
        }
        catch (Throwable e) {
            if (logger.isLoggable(JeusMessage_Client._53_LEVEL)) {
                logger.log(JeusMessage_Client._53_LEVEL, JeusMessage_Client._53, (Object)this.cls.getName(), e);
            }
            if (e instanceof InvalidAnnotationException) {
                throw (InvalidAnnotationException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }
}

