/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import jeus.container.namingenv.EjbRef;
import jeus.container.namingenv.EnvRef;
import jeus.container.namingenv.InjectionInfo;
import jeus.container.namingenv.JndiEnvironmentRefsGroup;
import jeus.container.namingenv.NamingEnvironment;
import jeus.container.namingenv.PersistenceContextRef;
import jeus.container.namingenv.PersistenceUnitRef;
import jeus.container.namingenv.ResourceRef;
import jeus.container.namingenv.ServiceRef;
import jeus.container.namingenv.SimpleEnvEntry;
import jeus.container.util.IntrospectionUtil;
import jeus.deploy.InvalidDescriptorException;
import jeus.xml.binding.j2ee.EjbLocalRefType;
import jeus.xml.binding.j2ee.EjbRefType;
import jeus.xml.binding.j2ee.EnvEntryType;
import jeus.xml.binding.j2ee.FullyQualifiedClassType;
import jeus.xml.binding.j2ee.InjectionTargetType;
import jeus.xml.binding.j2ee.LifecycleCallbackType;
import jeus.xml.binding.j2ee.MessageDestinationRefType;
import jeus.xml.binding.j2ee.PersistenceContextRefType;
import jeus.xml.binding.j2ee.PersistenceUnitRefType;
import jeus.xml.binding.j2ee.PropertyType;
import jeus.xml.binding.j2ee.ResourceEnvRefType;
import jeus.xml.binding.j2ee.ResourceRefType;
import jeus.xml.binding.j2ee.ServiceRefType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentDescriptorProcessor {
    public static final String RES_AUTH_APPLICATION = "Application";
    public static final String RES_AUTH_CONTAINER = "Container";
    public static final String RES_SHARING_SCOPE_UNSHAREABLE = "Unshareable";
    public static final String RES_SHARING_SCOPE_SHAREABLE = "Shareable";
    protected ClassLoader loader;
    protected NamingEnvironment env;
    protected JndiEnvironmentRefsGroup descriptorEnvRefs;

    public EnvironmentDescriptorProcessor(NamingEnvironment env, ClassLoader loader) {
        this.env = env == null ? new NamingEnvironment() : env;
        this.loader = loader;
    }

    public NamingEnvironment getNamingEnvironment() {
        return this.env;
    }

    public void process(JndiEnvironmentRefsGroup group) throws InvalidDescriptorException {
        this.descriptorEnvRefs = group;
        this.processSimpleEnvEntries();
        this.processEjbRefs();
        this.processServiceRefs();
        this.processResourceRefs();
        this.processResourceEnvRefs();
        this.processMessageDestiantionRefs();
        this.processPersistenceContextRefs();
        this.processPersistenceUnitRefs();
        this.processPostConstructCallbacks();
        this.processPreDestroyCallbacks();
    }

    private void addEntry(EnvRef entry) {
        entry.setGlobalScope(true);
        this.env.addEntryIfAbsent(entry);
    }

    private void processSimpleEnvEntries() throws InvalidDescriptorException {
        List<EnvEntryType> simpleEnvList = this.descriptorEnvRefs.getSimpleEnvEntryList();
        if (simpleEnvList != null) {
            for (EnvEntryType envEntry : simpleEnvList) {
                SimpleEnvEntry entry;
                String name = envEntry.getEnvEntryName().getValue();
                EnvRef existing = this.env.getEntry(name);
                if (existing == null) {
                    entry = new SimpleEnvEntry(name);
                } else {
                    if (!(existing instanceof SimpleEnvEntry)) {
                        EnvironmentDescriptorProcessor.throwDuplicateEntryException(name);
                    }
                    entry = (SimpleEnvEntry)existing;
                }
                Class type = entry.getType();
                if (envEntry.isSetEnvEntryType()) {
                    String typeName = envEntry.getEnvEntryType().getValue();
                    type = entry.overrideType(EnvironmentDescriptorProcessor.getSimpleEnvType(typeName));
                }
                if (type == null) {
                    throw new InvalidDescriptorException("<env-entry-type> should be given in environment entry " + name);
                }
                if (envEntry.isSetEnvEntryValue()) {
                    String envValue = envEntry.getEnvEntryValue().getValue();
                    entry.setValue(EnvironmentDescriptorProcessor.getSimpleEnvValue(type, envValue));
                }
                List injTargetList = envEntry.getInjectionTarget();
                this.processInjectionTarget(injTargetList, entry, type);
                this.addEntry(entry);
            }
        }
    }

    private void processEjbRefs() throws InvalidDescriptorException {
        List<EjbLocalRefType> ejbLocalRefList;
        String cls;
        List<EjbRefType> ejbRefList = this.descriptorEnvRefs.getEjbRefList();
        if (ejbRefList != null) {
            for (EjbRefType ejbRef : ejbRefList) {
                Class<?> givenType;
                String cls2;
                EjbRef entry;
                String name = ejbRef.getEjbRefName().getValue();
                EnvRef existing = this.env.getEntry(name);
                if (existing == null) {
                    entry = new EjbRef(name);
                } else {
                    if (!(existing instanceof EjbRef)) {
                        EnvironmentDescriptorProcessor.throwDuplicateEntryException(name);
                    }
                    entry = (EjbRef)existing;
                }
                Class<?> homeCls = null;
                if (ejbRef.isSetHome() && (cls2 = ejbRef.getHome().getValue().trim()).length() != 0) {
                    try {
                        homeCls = this.loader.loadClass(cls2);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new InvalidDescriptorException(ex);
                    }
                }
                Class<?> interfaceCls = null;
                if (ejbRef.isSetRemote() && (cls = ejbRef.getRemote().getValue().trim()).length() != 0) {
                    try {
                        interfaceCls = this.loader.loadClass(cls);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new InvalidDescriptorException(ex);
                    }
                }
                Class<?> type = entry.getBeanInterface();
                Class<?> clazz = givenType = homeCls != null ? homeCls : interfaceCls;
                if (givenType != null) {
                    entry.setType(givenType);
                    type = givenType;
                }
                entry.setRemote(true);
                if (ejbRef.isSetEjbLink()) {
                    String ejblink = ejbRef.getEjbLink().getValue().trim();
                    entry.setEjbLink(ejblink);
                }
                if (ejbRef.isSetMappedName()) {
                    String mappedName = ejbRef.getMappedName().getValue().trim();
                    entry.setMappedName(mappedName);
                }
                List injTargetList = ejbRef.getInjectionTarget();
                this.processInjectionTarget(injTargetList, entry, type);
                this.addEntry(entry);
            }
        }
        if ((ejbLocalRefList = this.descriptorEnvRefs.getEjbLocalRefList()) != null) {
            for (EjbLocalRefType ejbRef : ejbLocalRefList) {
                Class<?> givenType;
                String cls3;
                EjbRef entry;
                String name = ejbRef.getEjbRefName().getValue();
                EnvRef existing = this.env.getEntry(name);
                if (existing == null) {
                    entry = new EjbRef(name);
                } else {
                    if (!(existing instanceof EjbRef)) {
                        EnvironmentDescriptorProcessor.throwDuplicateEntryException(name);
                    }
                    entry = (EjbRef)existing;
                }
                Class<?> homeCls = null;
                if (ejbRef.isSetLocalHome() && (cls = ejbRef.getLocalHome().getValue().trim()).length() != 0) {
                    try {
                        homeCls = this.loader.loadClass(cls);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new InvalidDescriptorException(ex);
                    }
                }
                Class<?> interfaceCls = null;
                if (ejbRef.isSetLocal() && (cls3 = ejbRef.getLocal().getValue().trim()).length() != 0) {
                    try {
                        interfaceCls = this.loader.loadClass(cls3);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new InvalidDescriptorException(ex);
                    }
                }
                Class<?> type = entry.getBeanInterface();
                Class<?> clazz = givenType = homeCls != null ? homeCls : interfaceCls;
                if (givenType != null) {
                    entry.setType(givenType);
                    type = givenType;
                }
                entry.setRemote(false);
                if (ejbRef.isSetEjbLink()) {
                    String ejblink = ejbRef.getEjbLink().getValue().trim();
                    entry.setEjbLink(ejblink);
                }
                if (ejbRef.isSetMappedName()) {
                    String mappedName = ejbRef.getMappedName().getValue().trim();
                    entry.setMappedName(mappedName);
                }
                List injTargetList = ejbRef.getInjectionTarget();
                this.processInjectionTarget(injTargetList, entry, type);
                this.addEntry(entry);
            }
        }
    }

    private void processResourceRefs() throws InvalidDescriptorException {
        List<ResourceRefType> resRefList = this.descriptorEnvRefs.getResourceRefList();
        if (resRefList != null) {
            for (ResourceRefType ref : resRefList) {
                ResourceRef entry;
                String name = ref.getResRefName().getValue();
                EnvRef existing = this.env.getEntry(name);
                if (existing == null) {
                    entry = new ResourceRef(name);
                } else {
                    if (!(existing instanceof ResourceRef)) {
                        EnvironmentDescriptorProcessor.throwDuplicateEntryException(name);
                    }
                    entry = (ResourceRef)existing;
                }
                Class<?> type = entry.getType();
                if (ref.isSetResType()) {
                    String cls = ref.getResType().getValue();
                    try {
                        type = this.loader.loadClass(cls);
                        entry.setType(type);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new InvalidDescriptorException(ex);
                    }
                }
                if (ref.isSetResAuth()) {
                    if (ref.getResAuth().getValue().equals(RES_AUTH_APPLICATION)) {
                        entry.overrideAuthType(Resource.AuthenticationType.APPLICATION);
                    } else {
                        entry.overrideAuthType(Resource.AuthenticationType.CONTAINER);
                    }
                }
                if (ref.isSetResSharingScope()) {
                    if (ref.getResSharingScope().getValue().equals(RES_SHARING_SCOPE_UNSHAREABLE)) {
                        entry.overrideShareable(false);
                    } else {
                        entry.overrideShareable(true);
                    }
                }
                if (ref.isSetMappedName()) {
                    entry.setMappedName(ref.getMappedName().getValue().trim());
                }
                List injTargetList = ref.getInjectionTarget();
                this.processInjectionTarget(injTargetList, entry, type);
                this.addEntry(entry);
            }
        }
    }

    private void processResourceEnvRefs() throws InvalidDescriptorException {
        List<ResourceEnvRefType> resRefList = this.descriptorEnvRefs.getResourceEnvRefList();
        if (resRefList != null) {
            for (ResourceEnvRefType ref : resRefList) {
                ResourceRef entry;
                String name = ref.getResourceEnvRefName().getValue();
                EnvRef existing = this.env.getEntry(name);
                if (existing == null) {
                    entry = new ResourceRef(name);
                } else {
                    if (!(existing instanceof ResourceRef)) {
                        EnvironmentDescriptorProcessor.throwDuplicateEntryException(name);
                    }
                    entry = (ResourceRef)existing;
                }
                Class<?> type = entry.getType();
                if (ref.isSetResourceEnvRefType()) {
                    String cls = ref.getResourceEnvRefType().getValue();
                    try {
                        type = this.loader.loadClass(cls);
                        entry.setType(type);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new InvalidDescriptorException(ex);
                    }
                }
                if (ref.isSetMappedName()) {
                    entry.setMappedName(ref.getMappedName().getValue().trim());
                }
                List injTargetList = ref.getInjectionTarget();
                this.processInjectionTarget(injTargetList, entry, type);
                this.addEntry(entry);
            }
        }
    }

    private void processMessageDestiantionRefs() throws InvalidDescriptorException {
        List<MessageDestinationRefType> resRefList = this.descriptorEnvRefs.getMessageDestinationRefList();
        if (resRefList != null) {
            for (MessageDestinationRefType ref : resRefList) {
                ResourceRef entry;
                String name = ref.getMessageDestinationRefName().getValue();
                EnvRef existing = this.env.getEntry(name);
                if (existing == null) {
                    entry = new ResourceRef(name);
                } else {
                    if (!(existing instanceof ResourceRef)) {
                        EnvironmentDescriptorProcessor.throwDuplicateEntryException(name);
                    }
                    entry = (ResourceRef)existing;
                }
                Class<?> type = entry.getType();
                if (ref.isSetMessageDestinationType()) {
                    String cls = ref.getMessageDestinationType().getValue();
                    try {
                        type = this.loader.loadClass(cls);
                        entry.setType(type);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new InvalidDescriptorException(ex);
                    }
                }
                if (ref.isSetMessageDestinationLink()) {
                    String destinationLink = ref.getMessageDestinationLink().getValue();
                    entry.setMsgDestinationLink(destinationLink);
                }
                if (ref.isSetMappedName()) {
                    entry.setMappedName(ref.getMappedName().getValue().trim());
                }
                List injTargetList = ref.getInjectionTarget();
                this.processInjectionTarget(injTargetList, entry, type);
                this.addEntry(entry);
            }
        }
    }

    private void processPersistenceContextRefs() throws InvalidDescriptorException {
        List<PersistenceContextRefType> resRefList = this.descriptorEnvRefs.getPersistenceContextRefList();
        if (resRefList != null) {
            for (PersistenceContextRefType ref : resRefList) {
                PersistenceContextRef entry;
                String name = ref.getPersistenceContextRefName().getValue();
                EnvRef existing = this.env.getEntry(name);
                if (existing == null) {
                    entry = new PersistenceContextRef(name);
                } else {
                    if (!(existing instanceof PersistenceContextRef)) {
                        EnvironmentDescriptorProcessor.throwDuplicateEntryException(name);
                    }
                    entry = (PersistenceContextRef)existing;
                }
                if (ref.isSetPersistenceUnitName()) {
                    String unitName = ref.getPersistenceUnitName().getValue();
                    entry.overrideUnitName(unitName);
                }
                if (ref.isSetPersistenceContextType()) {
                    if (ref.getPersistenceContextType().getValue().equals("Extended")) {
                        entry.overrideType(PersistenceContextType.EXTENDED);
                    } else {
                        entry.overrideType(PersistenceContextType.TRANSACTION);
                    }
                }
                if (ref.isSetPersistenceProperty()) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    for (PropertyType property : ref.getPersistenceProperty()) {
                        properties.put(property.getName().getValue().trim(), property.getValue().getValue().trim());
                    }
                    entry.overrideProperties(properties);
                }
                Class<EntityManager> type = EntityManager.class;
                List injTargetList = ref.getInjectionTarget();
                this.processInjectionTarget(injTargetList, entry, type);
                this.addEntry(entry);
            }
        }
    }

    private void processPersistenceUnitRefs() throws InvalidDescriptorException {
        List<PersistenceUnitRefType> resRefList = this.descriptorEnvRefs.getPersistenceUnitRefList();
        if (resRefList != null) {
            for (PersistenceUnitRefType ref : resRefList) {
                PersistenceUnitRef entry;
                String name = ref.getPersistenceUnitRefName().getValue();
                EnvRef existing = this.env.getEntry(name);
                if (existing == null) {
                    entry = new PersistenceUnitRef(name);
                } else {
                    if (!(existing instanceof PersistenceUnitRef)) {
                        EnvironmentDescriptorProcessor.throwDuplicateEntryException(name);
                    }
                    entry = (PersistenceUnitRef)existing;
                }
                if (ref.isSetPersistenceUnitName()) {
                    String unitName = ref.getPersistenceUnitName().getValue();
                    entry.overrideUnitName(unitName);
                }
                Class<EntityManagerFactory> type = EntityManagerFactory.class;
                List injTargetList = ref.getInjectionTarget();
                this.processInjectionTarget(injTargetList, entry, type);
                this.addEntry(entry);
            }
        }
    }

    private void processServiceRefs() throws InvalidDescriptorException {
        List<ServiceRefType> serviceRefList = this.descriptorEnvRefs.getServiceRefList();
        if (serviceRefList != null) {
            for (ServiceRefType ref : serviceRefList) {
                ServiceRef entry;
                String name = ref.getServiceRefName().getValue();
                EnvRef existing = this.env.getEntry(name);
                if (existing == null) {
                    entry = new ServiceRef(name);
                } else {
                    if (!(existing instanceof ServiceRef)) {
                        EnvironmentDescriptorProcessor.throwDuplicateEntryException(name);
                    }
                    entry = (ServiceRef)existing;
                }
                entry.setServiceStdDd(ref);
                Class<?> serviceClass = entry.getServiceClass();
                if (ref.isSetServiceInterface()) {
                    String cls = ref.getServiceInterface().getValue();
                    try {
                        serviceClass = this.loader.loadClass(cls);
                        entry.setServiceClass(serviceClass);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new InvalidDescriptorException(ex);
                    }
                }
                if (serviceClass == null) {
                    throw new InvalidDescriptorException("<service-interface> should be given in environment entry " + name);
                }
                Class<?> type = entry.getType();
                if (ref.isSetServiceRefType()) {
                    String cls = ref.getServiceRefType().getValue();
                    try {
                        type = this.loader.loadClass(cls);
                        entry.setType(type);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new InvalidDescriptorException(ex);
                    }
                }
                if (ref.isSetWsdlFile()) {
                    entry.setWsdlLocation(ref.getWsdlFile().getValue());
                }
                if (ref.isSetMappedName()) {
                    entry.setMappedName(ref.getMappedName().getValue().trim());
                }
                if (ref.isSetHandlerChains()) {
                    try {
                        entry.processHandlerChains(ref.getHandlerChains(), this.env);
                    }
                    catch (Exception e) {
                        throw new InvalidDescriptorException(e);
                    }
                }
                List injTargetList = ref.getInjectionTarget();
                this.processInjectionTarget(injTargetList, entry, type);
                this.addEntry(entry);
            }
        }
    }

    private void processInjectionTarget(List<InjectionTargetType> injTargetList, EnvRef entry, Class type) throws InvalidDescriptorException {
        if (injTargetList != null) {
            for (InjectionTargetType injectionTarget : injTargetList) {
                try {
                    InjectionInfo injection = this.composeInjectionInfoFrom(entry, injectionTarget, type);
                    this.env.addInjectionInfo(injection);
                    if (type != null) continue;
                    type = injection.getTargetType();
                    entry.setType(type);
                }
                catch (Exception ex) {
                    throw new InvalidDescriptorException(ex);
                }
            }
        }
    }

    private InjectionInfo composeInjectionInfoFrom(EnvRef entry, InjectionTargetType injectionTarget, Class propertyType) throws Exception {
        String className = injectionTarget.getInjectionTargetClass().getValue();
        String propertyName = injectionTarget.getInjectionTargetName().getValue();
        Class<?> cls = this.loader.loadClass(className);
        Member member = EnvironmentDescriptorProcessor.getPropertyMember(cls, propertyName, propertyType);
        return new InjectionInfo(entry.getName(), member);
    }

    private static Member getPropertyMember(Class cls, String propertyName, Class propertyType) {
        Method method = IntrospectionUtil.getSetterMethod(cls, propertyName, propertyType);
        if (method != null) {
            return method;
        }
        try {
            return cls.getDeclaredField(propertyName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("There is no field or setter method - " + cls.getName() + "." + propertyName);
        }
    }

    public static Class getSimpleEnvType(String typeName) throws InvalidDescriptorException {
        Class type;
        if (typeName.equals("int") || typeName.equals("Integer") || typeName.equals("java.lang.Integer")) {
            type = Integer.class;
        } else if (typeName.equals("long") || typeName.equals("Long") || typeName.equals("java.lang.Long")) {
            type = Long.class;
        } else if (typeName.equals("float") || typeName.equals("Float") || typeName.equals("java.lang.Float")) {
            type = Float.class;
        } else if (typeName.equals("boolean") || typeName.equals("Boolean") || typeName.equals("java.lang.Boolean")) {
            type = Boolean.class;
        } else if (typeName.equals("double") || typeName.equals("Double") || typeName.equals("java.lang.Double")) {
            type = Double.class;
        } else if (typeName.equals("byte") || typeName.equals("Byte") || typeName.equals("java.lang.Byte")) {
            type = Byte.class;
        } else if (typeName.equals("short") || typeName.equals("Short") || typeName.equals("java.lang.Short")) {
            type = Short.class;
        } else if (typeName.equals("char") || typeName.equals("Char") || typeName.equals("java.lang.Character")) {
            type = Character.class;
        } else if (typeName.equals("java.lang.String") || typeName.equals("String")) {
            type = String.class;
        } else {
            throw new InvalidDescriptorException(typeName + " is not valid type for simple entry");
        }
        return type;
    }

    public static Object getSimpleEnvValue(Class type, String strValue) throws InvalidDescriptorException {
        Object value;
        block11: {
            try {
                if (type == Integer.TYPE || type == Integer.class) {
                    value = Integer.valueOf(strValue);
                    break block11;
                }
                if (type == Long.TYPE || type == Long.class) {
                    value = Long.valueOf(strValue);
                    break block11;
                }
                if (type == Float.TYPE || type == Float.class) {
                    value = Float.valueOf(strValue);
                    break block11;
                }
                if (type == Boolean.TYPE || type == Boolean.class) {
                    value = Boolean.valueOf(strValue);
                    break block11;
                }
                if (type == Double.TYPE || type == Double.class) {
                    value = Double.valueOf(strValue);
                    break block11;
                }
                if (type == Byte.TYPE || type == Byte.class) {
                    value = Byte.valueOf(strValue);
                    break block11;
                }
                if (type == Short.TYPE || type == Short.class) {
                    value = Short.valueOf(strValue);
                    break block11;
                }
                if (type == Character.TYPE || type == Character.class) {
                    char[] carray = strValue.toCharArray();
                    value = new Character(carray[0]);
                    break block11;
                }
                if (type == String.class) {
                    value = strValue;
                    break block11;
                }
                throw new InvalidDescriptorException(type + " is not valid type for simple entry");
            }
            catch (NumberFormatException e) {
                throw new InvalidDescriptorException("Invalid format", e);
            }
        }
        return value;
    }

    private static void throwDuplicateEntryException(String name) throws InvalidDescriptorException {
        throw new InvalidDescriptorException("Environment entry " + name + " is already defined as another type");
    }

    private void processPreDestroyCallbacks() throws InvalidDescriptorException {
        List<LifecycleCallbackType> callbacks = this.descriptorEnvRefs.getPreDestroyList();
        if (callbacks == null) {
            return;
        }
        for (LifecycleCallbackType callback : callbacks) {
            try {
                Class<?> cls;
                if (callback.isSetLifecycleCallbackClass()) {
                    cls = this.getClassOf(callback.getLifecycleCallbackClass());
                } else {
                    String componentClassName = this.descriptorEnvRefs.getComponentClassName();
                    if (componentClassName == null) {
                        throw new InvalidDescriptorException("lifecycle-callback-class should be given");
                    }
                    cls = this.loader.loadClass(componentClassName);
                }
                String methodName = callback.getLifecycleCallbackMethod().getValue().trim();
                Method method = cls.getDeclaredMethod(methodName, new Class[0]);
                this.env.addPreDestroyMethod(method);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidDescriptorException(e);
            }
            catch (NoSuchMethodException e) {
                throw new InvalidDescriptorException(e);
            }
        }
    }

    private void processPostConstructCallbacks() throws InvalidDescriptorException {
        List<LifecycleCallbackType> callbacks = this.descriptorEnvRefs.getPostConstructList();
        if (callbacks == null) {
            return;
        }
        for (LifecycleCallbackType callback : callbacks) {
            try {
                Class<?> cls;
                if (callback.isSetLifecycleCallbackClass()) {
                    cls = this.getClassOf(callback.getLifecycleCallbackClass());
                } else {
                    String componentClassName = this.descriptorEnvRefs.getComponentClassName();
                    if (componentClassName == null) {
                        throw new InvalidDescriptorException("lifecycle-callback-class should be given");
                    }
                    cls = this.loader.loadClass(componentClassName);
                }
                String methodName = callback.getLifecycleCallbackMethod().getValue().trim();
                Method method = cls.getDeclaredMethod(methodName, new Class[0]);
                this.env.addPostConstructMethod(method);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidDescriptorException(e);
            }
            catch (NoSuchMethodException e) {
                throw new InvalidDescriptorException(e);
            }
        }
    }

    protected Class getClassOf(FullyQualifiedClassType classType) throws ClassNotFoundException {
        return Class.forName(classType.getValue().trim(), false, this.loader);
    }
}

