/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jeus.container.namingenv.InjectionException;
import jeus.util.ReflectionUtils;

public class InjectionInfo {
    protected InjectionType memberType;
    protected Member member;
    protected Class targetType;
    protected String envName;

    public InjectionInfo(String envName, Member member) throws IllegalArgumentException {
        this.envName = envName;
        this.member = member;
        if (member instanceof Field) {
            this.memberType = InjectionType.FIELD;
            Field field = (Field)member;
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers)) {
                throw new IllegalArgumentException("injection field should not be final");
            }
            this.targetType = field.getType();
        } else if (member instanceof Method) {
            this.memberType = InjectionType.METHOD;
            Method setMethod = (Method)member;
            Class<?>[] paramTypes = setMethod.getParameterTypes();
            if (paramTypes.length != 1) {
                throw new IllegalArgumentException("injection method should have one parameter");
            }
            this.targetType = paramTypes[0];
        } else {
            throw new IllegalArgumentException("member is not field nor method");
        }
    }

    public Class getTargetType() {
        return this.targetType;
    }

    public InjectionType getMemberType() {
        return this.memberType;
    }

    public Member getMember() {
        return this.member;
    }

    public Class getDeclaringClass() {
        return this.member.getDeclaringClass();
    }

    public String getEnvName() {
        return this.envName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void inject(Object targetInstance, Object value) throws InjectionException {
        boolean turnedOn = false;
        AccessibleObject accessible = (AccessibleObject)((Object)this.member);
        try {
            if (!accessible.isAccessible()) {
                ReflectionUtils.setAccessible(accessible, true);
                turnedOn = true;
            }
            switch (this.memberType) {
                case FIELD: {
                    Field field = (Field)this.member;
                    field.set(targetInstance, value);
                    return;
                }
                case METHOD: {
                    Method method = (Method)this.member;
                    method.invoke(targetInstance, value);
                    return;
                }
            }
            return;
        }
        catch (IllegalArgumentException ex) {
            throw new InjectionException("Injection failed - value is not assignable: expected type = " + this.targetType + ", value type = " + value.getClass(), ex);
        }
        catch (Exception ex) {
            throw new InjectionException("Injection failed - " + this.member, ex);
        }
        finally {
            if (turnedOn) {
                try {
                    ReflectionUtils.setAccessible(accessible, false);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public int hashCode() {
        return this.getMember().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof InjectionInfo) {
            InjectionInfo that = (InjectionInfo)o;
            return this.envName.equals(that.envName) && this.member.equals(that.member);
        }
        return false;
    }

    public String toString() {
        return "InjectionInfo:envName=" + this.envName + ",member=" + (Object)((Object)this.memberType) + ":" + this.member;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InjectionType {
        FIELD,
        METHOD;

    }
}

