/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import jeus.container.namingenv.ClassEnvInfo;
import jeus.container.namingenv.DuplicateEntryException;
import jeus.container.namingenv.EnvRef;
import jeus.container.namingenv.InjectionInfo;
import jeus.container.namingenv.PersistenceContextRef;
import jeus.container.namingenv.PersistenceUnitRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingEnvironment {
    protected Map<String, EnvRef> entries = new HashMap<String, EnvRef>();
    protected Map<String, ClassEnvInfo> clasInfos = new HashMap<String, ClassEnvInfo>();

    void initClassInfo(Class cls) {
        ClassEnvInfo clsInfo = this.clasInfos.get(cls.getName());
        if (clsInfo != null) {
            clsInfo.init(cls);
        }
    }

    public void addEntry(Class cls, EnvRef entry) {
        String name = entry.getName();
        EnvRef existing = this.entries.get(name);
        if (existing != null) {
            if (existing.isGlobalScope()) {
                // empty if block
            }
            entry = existing;
        } else {
            this.entries.put(name, entry);
        }
        ClassEnvInfo clsInfo = this.getClassInfo0(cls);
        clsInfo.addEntry(entry);
    }

    public void addEntryIfAbsent(EnvRef entry) {
        if (this.entries.get(entry.getName()) != null) {
            return;
        }
        this.addEntry0(entry);
    }

    private void addEntry0(EnvRef entry) {
        this.entries.put(entry.getName(), entry);
    }

    public EnvRef getEntry(String name) {
        return this.entries.get(name);
    }

    public Collection<EnvRef> entries() {
        return this.entries.values();
    }

    public Iterator<EnvRef> getEntryIterator() {
        return this.entries.values().iterator();
    }

    public Collection<PersistenceUnitRef> getPersistenceUnitReferences() {
        LinkedList<PersistenceUnitRef> list = new LinkedList<PersistenceUnitRef>();
        for (EnvRef ref : this.entries.values()) {
            if (!(ref instanceof PersistenceUnitRef)) continue;
            list.add((PersistenceUnitRef)ref);
        }
        return list;
    }

    public Collection<PersistenceContextRef> getPersistenceContextReferences() {
        LinkedList<PersistenceContextRef> list = new LinkedList<PersistenceContextRef>();
        for (EnvRef ref : this.entries.values()) {
            if (!(ref instanceof PersistenceContextRef)) continue;
            list.add((PersistenceContextRef)ref);
        }
        return list;
    }

    ClassEnvInfo getClassEnvInfo(Class cls) {
        return this.clasInfos.get(cls.getName());
    }

    public void addInjectionInfo(InjectionInfo injection) {
        assert (injection != null);
        Class cls = injection.getDeclaringClass();
        ClassEnvInfo clsInfo = this.getClassInfo0(cls);
        clsInfo.addInjectionTarget(injection);
    }

    public InjectionInfo getInjectionInfo(Member member) {
        Class<?> cls = member.getDeclaringClass();
        ClassEnvInfo clsInfo = this.getClassInfo0(cls);
        if (clsInfo == null) {
            return null;
        }
        return clsInfo.getInjectionInfo(member);
    }

    Iterator<ClassEnvInfo> getClassEnvInfoIterator() {
        return this.clasInfos.values().iterator();
    }

    void addPostConstructMethod(Method method) {
        Class<?> cls = method.getDeclaringClass();
        ClassEnvInfo clsInfo = this.getClassInfo0(cls);
        clsInfo.setPostConstructMethod(method);
    }

    void addPreDestroyMethod(Method method) {
        Class<?> cls = method.getDeclaringClass();
        ClassEnvInfo clsInfo = this.getClassInfo0(cls);
        clsInfo.setPreDestroyMethod(method);
    }

    public void mergeWith(NamingEnvironment env) throws DuplicateEntryException {
        for (EnvRef envRef : env.entries()) {
            String name = envRef.getName();
            EnvRef existing = this.entries.get(name);
            if (existing != null) {
                if (existing.equals(envRef)) continue;
                throw new DuplicateEntryException(name + " is defined already as another reference");
            }
            this.entries.put(name, envRef);
        }
        Iterator<ClassEnvInfo> iterator = env.getClassEnvInfoIterator();
        while (iterator.hasNext()) {
            ClassEnvInfo clsInfo = iterator.next();
            this.clasInfos.put(clsInfo.getTargetClass().getName(), clsInfo);
        }
    }

    private ClassEnvInfo getClassInfo0(Class cls) {
        String className = cls.getName();
        ClassEnvInfo clsInfo = this.clasInfos.get(className);
        if (clsInfo == null) {
            clsInfo = new ClassEnvInfo(cls);
            this.clasInfos.put(className, clsInfo);
        }
        return clsInfo;
    }
}

