/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import jeus.client.container.ClientContainer;
import jeus.container.ExecutionModule;
import jeus.container.namingenv.EnvRef;
import jeus.container.namingenv.EnvironmentContext;
import jeus.container.namingenv.EnvironmentException;
import jeus.persistence.container.PersistenceUnit;
import jeus.persistence.container.PersistenceUnitNotFoundException;

public class PersistenceUnitRef
extends EnvRef {
    protected String unitName = "";

    public PersistenceUnitRef(String name) {
        super(name);
    }

    public PersistenceUnitRef(String name, String unitName) {
        super(name);
        this.unitName = unitName;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void overrideUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Object getBindingObject(EnvironmentContext context) throws EnvironmentException {
        try {
            if (context.isServerMode()) {
                ExecutionModule module = context.getModule();
                PersistenceUnit pu = module.lookupPersistenceUnit(this.unitName);
                return pu.createManagedEntityManagerFactory();
            }
            PersistenceUnit pu = ClientContainer.lookupPersistenceUnit(this.unitName);
            return pu.createManagedEntityManagerFactory();
        }
        catch (PersistenceUnitNotFoundException ex) {
            throw new EnvironmentException("Could not find persistence unit '" + this.unitName + "'.", ex);
        }
    }
}

