/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.ejb.TimerService;
import javax.jms.Destination;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import jeus.container.ExecutionModule;
import jeus.container.namingenv.EnvRef;
import jeus.container.namingenv.EnvironmentContext;
import jeus.container.namingenv.EnvironmentException;
import jeus.container.namingenv.JndiEnvironmentMappingGroup;
import jeus.container.namingenv.URLObjectFactory;
import jeus.container.resource.ResourceRefHelper;
import jeus.transaction.TxHelper;
import org.omg.CORBA.ORB;

public class ResourceRef
extends EnvRef {
    private static final String ORB_URL = "java:comp/ORB";
    private static final String USERTRANSACTION_URL = "java:comp/UserTransaction";
    private static final String TSR_URL = "java:comp/TransactionSynchronizationRegistry";
    private static final String EJBCONTEXT_URL = "java:comp/EJBContext";
    private static final String TIMERSERVICE_URL = "java:comp/TimerService";
    protected Class type;
    protected Resource.AuthenticationType authType = ResourceRefHelper.DEFAULT_AUTH_TYPE;
    protected boolean shareable = true;
    protected String msgDestinationLink;

    public ResourceRef(String name) {
        super(name);
    }

    public ResourceRef(String name, Class type) {
        this(name, type, Resource.AuthenticationType.CONTAINER, true);
    }

    public ResourceRef(String name, Class type, Resource.AuthenticationType authType, boolean shareable) {
        super(name);
        this.type = type;
        this.authType = authType;
        this.shareable = shareable;
    }

    public Class getType() {
        return this.type;
    }

    public Resource.AuthenticationType getAuthType() {
        return this.authType;
    }

    public boolean isShareable() {
        return this.shareable;
    }

    public String getMsgDestinationLink() {
        return this.msgDestinationLink;
    }

    public void setType(Class type) {
        if (this.type == null) {
            this.type = type;
        }
    }

    public void overrideAuthType(Resource.AuthenticationType type) {
        this.authType = type;
    }

    public void overrideShareable(boolean shareable) {
        this.shareable = shareable;
    }

    public void setMsgDestinationLink(String msgDestinationLink) {
        this.msgDestinationLink = msgDestinationLink;
    }

    public boolean isMessageDestinationRef() {
        return Destination.class.isAssignableFrom(this.type);
    }

    public Object getBindingObject(EnvironmentContext context) throws EnvironmentException {
        Object value = null;
        String jndiName = null;
        if (this.type == null) {
            throw new EnvironmentException("type is not defined for environment entry '" + this.name + "'");
        }
        ExecutionModule module = context.getModule();
        if (this.type == UserTransaction.class) {
            jndiName = USERTRANSACTION_URL;
        } else if (this.type == TransactionSynchronizationRegistry.class) {
            value = TxHelper.getTransactionSynchronizationRegistry();
        } else if (ORB.class.isAssignableFrom(this.type)) {
            jndiName = ORB_URL;
        } else if (this.type == TimerService.class) {
            jndiName = TIMERSERVICE_URL;
        } else if (EJBContext.class.isAssignableFrom(this.type)) {
            jndiName = EJBCONTEXT_URL;
        } else if (this.type == URL.class) {
            String urlString = this.getResourceMappingJndiName(context.getEnvironmentMapping());
            if (urlString != null) {
                try {
                    value = new URL(urlString);
                    if (!this.shareable) {
                        StringRefAddr addr = new StringRefAddr("url", urlString);
                        String factory = URLObjectFactory.class.getName();
                        value = new Reference(URL.class.getName(), addr, factory, null);
                    }
                }
                catch (MalformedURLException ex) {
                    jndiName = urlString;
                }
            }
        } else if (this.isMessageDestinationRef()) {
            jndiName = this.getMsgDestMappingJndiName(context.getEnvironmentMapping());
            if (jndiName == null && this.msgDestinationLink != null && module != null) {
                jndiName = module.getMessageDestinationJndiNameWithLink(this.msgDestinationLink);
            }
        } else {
            jndiName = this.getResourceMappingJndiName(context.getEnvironmentMapping());
        }
        if (value != null) {
            return value;
        }
        if (jndiName == null) {
            jndiName = this.name;
        }
        return ResourceRefHelper.createPropertyLinkRef(jndiName, this.shareable, this.authType);
    }

    private String getResourceMappingJndiName(JndiEnvironmentMappingGroup mapping) {
        String jndiName = this.getMatchingJndiName(mapping.getResRefMapping());
        if (jndiName == null) {
            jndiName = this.getMatchingJndiName(mapping.getResEnvMapping());
        }
        if (jndiName == null) {
            jndiName = this.mappedName;
        }
        return jndiName;
    }

    private String getMsgDestMappingJndiName(JndiEnvironmentMappingGroup mapping) {
        String jndiName = this.getMatchingJndiName(mapping.getMessageDistinationMapping());
        if (jndiName == null) {
            jndiName = this.getMatchingJndiName(mapping.getResEnvMapping());
        }
        if (jndiName == null) {
            jndiName = this.mappedName;
        }
        return jndiName;
    }
}

