/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.security;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.RunAs;
import jeus.container.annotation.AnnotationProcessor;
import jeus.container.security.MethodSecurityInfo;
import jeus.container.security.SecurityAnnotationInfo;
import jeus.deploy.InvalidAnnotationException;
import jeus.util.ClassUtil;

public class SecurityAnnotationProcessor
implements AnnotationProcessor {
    private SecurityAnnotationInfo securityInfo = new SecurityAnnotationInfo();
    private boolean ignoreMethodLevel;

    public SecurityAnnotationInfo getSecurityInfo() {
        return this.securityInfo;
    }

    public boolean isIgnoreMethodLevel() {
        return this.ignoreMethodLevel;
    }

    public void setIgnoreMethodLevel(boolean ignore) {
        this.ignoreMethodLevel = ignore;
    }

    public void processClass(Class cls) throws InvalidAnnotationException {
        this.securityInfo.setClassName(cls.getName());
        List<DeclareRoles> rolesList = ClassUtil.getAllAnnotations(cls, DeclareRoles.class, Object.class);
        ArrayList<String> roles = new ArrayList<String>();
        for (DeclareRoles declareRoles : rolesList) {
            String[] value = declareRoles.value();
            if (value == null || value.length <= 0) continue;
            for (String v : value) {
                roles.add(v);
            }
        }
        this.securityInfo.setDeclaredRoles(roles);
        if (cls.isAnnotationPresent(RunAs.class)) {
            String runAs = cls.getAnnotation(RunAs.class).value();
            this.securityInfo.setRunAsRole(runAs);
        }
    }

    public void processField(Field field) throws InvalidAnnotationException {
    }

    public void processConstructor(Constructor constructor) throws InvalidAnnotationException {
    }

    public void processMethod(Method m) throws InvalidAnnotationException {
        Class<?> declClass;
        if (this.ignoreMethodLevel) {
            return;
        }
        int mods = m.getModifiers();
        if (!Modifier.isPublic(mods) || Modifier.isStatic(mods)) {
            return;
        }
        MethodSecurityInfo methodInfo = m.isAnnotationPresent(DenyAll.class) ? MethodSecurityInfo.createDeniedAll(m) : (m.isAnnotationPresent(RolesAllowed.class) ? MethodSecurityInfo.createRoleAllowed(m, this.getRolesAllowed(m)) : (m.isAnnotationPresent(PermitAll.class) ? MethodSecurityInfo.createPermittedAll(m) : ((declClass = m.getDeclaringClass()).isAnnotationPresent(RolesAllowed.class) ? MethodSecurityInfo.createRoleAllowed(m, this.getRolesAllowed(declClass)) : (declClass.isAnnotationPresent(PermitAll.class) ? MethodSecurityInfo.createPermittedAll(m) : MethodSecurityInfo.createUnspecified(m)))));
        this.securityInfo.addMethodSecurityInfo(methodInfo);
    }

    public void processFinished() {
    }

    private String[] getRolesAllowed(AnnotatedElement element) {
        RolesAllowed roles = element.getAnnotation(RolesAllowed.class);
        if (roles != null) {
            return roles.value();
        }
        return null;
    }
}

