/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanException;
import jeus.deploy.status.DeploymentStatusImpl;
import jeus.util.logging.JeusLogger;

public class CommandBarrier
implements ProgressListener {
    private int parties;
    private int count;
    private boolean completed;
    private List completedList = new ArrayList();
    private List failedList = new ArrayList();
    private static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");

    public CommandBarrier(int parties) {
        this.parties = parties;
        if (parties <= 0) {
            this.completed = true;
        }
    }

    public synchronized void handleProgressEvent(ProgressEvent event) {
        StateType state = event.getDeploymentStatus().getState();
        if (!this.completed && (StateType.COMPLETED.equals(state) || StateType.FAILED.equals(state))) {
            ++this.count;
            if (this.count == this.parties) {
                this.completed = true;
                this.notifyAll();
            }
            if (StateType.COMPLETED.equals(state)) {
                this.completedList.add(event.getTargetModuleID());
            } else {
                this.failedList.add(event.getTargetModuleID());
                Exception e = ((DeploymentStatusImpl)event.getDeploymentStatus()).getFailException();
                if (e instanceof MBeanException) {
                    Exception e1 = ((MBeanException)e).getTargetException();
                    if (e1 instanceof InstanceAlreadyExistsException) {
                        String obj = e1.getMessage();
                        int index = obj.indexOf("j2eeType=");
                        int lastIndex = obj.indexOf(44, index);
                        String j2eeType = obj.substring(index + 9, lastIndex);
                        index = obj.indexOf("name=");
                        lastIndex = obj.indexOf(44, index);
                        String name = obj.substring(index + 5, lastIndex);
                        System.err.println("[Detail] the " + j2eeType + " " + name + " is already deployed");
                    } else {
                        System.err.println("Exception occurred during deployment: " + e.getMessage());
                    }
                    e.printStackTrace();
                } else {
                    System.err.println("Exception occurred during deployment: " + e.getMessage());
                }
                e.printStackTrace();
            }
        }
    }

    public synchronized List getCompletedList() {
        return Collections.unmodifiableList(this.completedList);
    }

    public synchronized List getFailedList() {
        return Collections.unmodifiableList(this.failedList);
    }

    public synchronized boolean isCompleted() {
        return this.completed;
    }
}

