/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.command;

import java.io.File;
import java.util.Map;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.ObjectName;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.ObjectNameTarget;
import jeus.deploy.PermanentTarget;
import jeus.deploy.command.AbstractCommand;
import jeus.deploy.command.CommandException;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Deploy;
import jeus.xml.binding.jeusDD.ApplicationType;

public class DistributeCommand
extends AbstractCommand {
    public static final String LEADER_KEY = "jeus.deploy.commmand.DistributeCommand.Leader";
    public static final String CONFIG_KEY = "jeus.deploy.commmand.DistributeCommand.Config";
    public static final String CONTEXT_GROUP = "jeus.deploy.commmand.DistributeCommand.ContextGroup";
    public static final String CONTEXT_NAME = "jeus.deploy.commmand.DistributeCommand.ContextName";
    public static final String DOCBASE = "jeus.deploy.commmand.DistributeCommand.Docbase";
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.deploy.distribute");
    private ApplicationType config;
    private ObjectNameTarget leader;
    private String contextName;
    private String contextGroup;
    private String docbase;

    public void setParameters(Map paramsMap) {
        super.setParameters(paramsMap);
        this.config = (ApplicationType)paramsMap.get(CONFIG_KEY);
        this.leader = (ObjectNameTarget)paramsMap.get(LEADER_KEY);
        this.contextName = (String)paramsMap.get(CONTEXT_NAME);
        this.docbase = (String)paramsMap.get(DOCBASE);
        this.contextGroup = (String)paramsMap.get(CONTEXT_GROUP);
    }

    protected void doCommand() throws Exception {
        TargetModuleID targetModuleID;
        MEJBUtility msFacade = this.getMBeanServerFacade();
        ObjectNameTarget target = this.getTarget();
        if (this.leader == null) {
            targetModuleID = this.docbase == null ? (TargetModuleID)msFacade.invoke(target.getObjectName(), "deploy", new Object[]{this.config}, new String[]{ApplicationType.class.getName()}) : (TargetModuleID)msFacade.invoke(target.getObjectName(), "deployWebContext", new Object[]{this.contextGroup, this.contextName, this.docbase}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()});
        } else {
            File temp = new File(JeusDeploymentManager.getApplicationPath(this.config));
            String leaderAbsPath = temp.isAbsolute() ? JeusDeploymentManager.getApplicationPath(this.config) : this.getLeaderAbsolutePath(this.config, this.leader, msFacade);
            String srcPath = null;
            if (leaderAbsPath != null) {
                srcPath = "abs:" + leaderAbsPath;
            }
            if (srcPath == null) {
                throw new CommandException("Can't find source module path for " + JeusDeploymentManager.getNameFromPath(this.config));
            }
            String node = target instanceof PermanentTarget ? this.leader.getName() : this.leader.getObjectName().getKeyProperty("JeusManager");
            targetModuleID = (TargetModuleID)msFacade.invoke(target.getObjectName(), "deploy", new Object[]{node, srcPath, this.config}, new String[]{String.class.getName(), String.class.getName(), ApplicationType.class.getName()});
        }
        this.setTargetModuleID(targetModuleID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLeaderAbsolutePath(ApplicationType app, ObjectNameTarget leader, MEJBUtility msFacade) {
        String modulePath;
        block9: {
            ObjectName[] j2eeServers;
            String moduleName;
            block11: {
                block10: {
                    moduleName = JeusDeploymentManager.getApplicationPath(app);
                    if (logger.isLoggable(JeusLevel.DEV)) {
                        logger.debug("[sebong] distribute - Leader Module Name : " + moduleName);
                    }
                    modulePath = null;
                    if (!(leader instanceof PermanentTarget)) break block10;
                    j2eeServers = new ObjectName[]{};
                    try {
                        j2eeServers = (ObjectName[])msFacade.getAttribute(leader.getObjectName(), "j2eeServerNames");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (j2eeServers == null || j2eeServers.length <= 0) break block9;
                    break block11;
                }
                try {
                    modulePath = (String)msFacade.invoke(leader.getObjectName(), "getModulePath", new Object[]{moduleName}, new String[]{String.class.getName()});
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_Deploy._10_LEVEL)) break block9;
                    logger.log(JeusMessage_Deploy._10_LEVEL, JeusMessage_Deploy._10, (Throwable)e);
                }
                break block9;
            }
            for (int i = 0; i < j2eeServers.length; ++i) {
                try {
                    modulePath = (String)msFacade.invoke(leader.getObjectName(), "getModulePath", new Object[]{moduleName}, new String[]{String.class.getName()});
                }
                catch (Exception e) {
                    continue;
                }
                if (modulePath != null) break;
            }
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.debug("[sebong] distribute - Leader Module Path : " + modulePath);
        }
        return modulePath;
    }

    public CommandType getCommandType() {
        return CommandType.DISTRIBUTE;
    }
}

