/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jeus.deploy.config.DConfigBeanRootSpecification;
import jeus.deploy.config.DConfigBeanSpecification;
import jeus.deploy.config.DConfigBeanSpecificationSource;
import jeus.deploy.config.DDBeanReference;
import jeus.xml.util.IXPathAPI;
import jeus.xml.util.XPathAPIFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DConfigBeanSpecificationParser {
    private static Map moduleTypeMap = new HashMap();
    private Properties _references;
    private Map _namespaceMap;
    private Map _rootMap;
    public static final String REFERENCE_RESOURCE = "jeus.deploy.config.reference_resource";

    public Map parse(InputStream is) {
        this._references = new Properties();
        this._namespaceMap = new HashMap();
        this._rootMap = new HashMap();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(is);
            IXPathAPI xpathAPI = XPathAPIFactory.createXPathAPI();
            this.parseNamespace(xpathAPI, document);
            this.parseRoot(xpathAPI, document);
            this._rootMap.put(REFERENCE_RESOURCE, this._references);
            return this._rootMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void parseRoot(IXPathAPI xpathAPI, Document document) throws Exception {
        NodeList roots = xpathAPI.selectNodeList(document, "/dconfigbeans/dconfigbean-root");
        for (int i = 0; i < roots.getLength(); ++i) {
            Node root = roots.item(i);
            Node namespace = xpathAPI.selectSingleNode(root, "namespace/text()");
            Node rootElement = xpathAPI.selectSingleNode(root, "root-element/text()");
            Node filename = xpathAPI.selectSingleNode(root, "filename/text()");
            Node ddbeanFilename = xpathAPI.selectSingleNode(root, "ddbean-root/filename/text()");
            Node moduleType = xpathAPI.selectSingleNode(root, "ddbean-root/module-type/text()");
            Node classname = xpathAPI.selectSingleNode(root, "class-name/text()");
            Node xmluiname = xpathAPI.selectSingleNode(root, "xmlui-name/text()");
            Node xmluipath = xpathAPI.selectSingleNode(root, "xmlui-path/text()");
            DConfigBeanRootSpecification spec = new DConfigBeanRootSpecification();
            spec.setNamespace(namespace.getNodeValue());
            spec.setRootElement(rootElement.getNodeValue());
            spec.setFilename(filename.getNodeValue());
            spec.setDdbeanFilename(ddbeanFilename.getNodeValue());
            spec.setModuleType((ModuleType)moduleTypeMap.get(moduleType.getNodeValue()));
            spec.setClassname(classname.getNodeValue());
            spec.setXmluiname(xmluiname.getNodeValue());
            spec.setXmluipath(xmluipath.getNodeValue());
            NodeList children = xpathAPI.selectNodeList(root, "child-dconfigbean/text()");
            if (children == null) continue;
            ArrayList<DConfigBeanSpecification> dconfigbeans = new ArrayList<DConfigBeanSpecification>();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                DConfigBeanSpecification childSpec = this.parseChild(xpathAPI, document, child.getNodeValue(), "/'" + spec.getNamespace() + "':" + spec.getRootElement());
                if (childSpec == null) continue;
                dconfigbeans.add(childSpec);
            }
            spec.setChildren(dconfigbeans.toArray(new DConfigBeanSpecification[dconfigbeans.size()]));
            this._rootMap.put(DConfigBeanSpecificationSource.buildKey(spec.getModuleType(), spec.getDdbeanFilename()), spec);
        }
    }

    private DConfigBeanSpecification parseChild(IXPathAPI xpathAPI, Document document, String id, String parentXpath) throws Exception {
        Node xml_bean = xpathAPI.selectSingleNode(document, "/dconfigbeans/dconfigbean[class-name='" + id + "']");
        if (xml_bean == null) {
            return null;
        }
        DConfigBeanSpecification spec = new DConfigBeanSpecification();
        Node xml_classname = xpathAPI.selectSingleNode(xml_bean, "class-name/text()");
        Node xml_xmluiname = xpathAPI.selectSingleNode(xml_bean, "xmlui-name/text()");
        Node xml_xmluipath = xpathAPI.selectSingleNode(xml_bean, "xmlui-path/text()");
        spec.setClassname(xml_classname.getNodeValue());
        spec.setXmluiname(xml_xmluiname.getNodeValue());
        spec.setXmluipath(xml_xmluipath.getNodeValue());
        Node xml_ddbeanXpath = xpathAPI.selectSingleNode(xml_bean, "ddbean-xpath/text()");
        spec.setDDBeanXPath(xml_ddbeanXpath.getNodeValue());
        ArrayList<DDBeanReference> ddbeanRefs = new ArrayList<DDBeanReference>();
        NodeList xml_ddbeanRefs = xpathAPI.selectNodeList(xml_bean, "ddbean-ref");
        for (int i = 0; i < xml_ddbeanRefs.getLength(); ++i) {
            Node xml_ddbeanRef = xml_ddbeanRefs.item(i);
            Node xml_key = xpathAPI.selectSingleNode(xml_ddbeanRef, "@key");
            Node xml_srcXpath = xpathAPI.selectSingleNode(xml_ddbeanRef, "src-xpath/text()");
            Node xml_refXpath = xpathAPI.selectSingleNode(xml_ddbeanRef, "ref-xpath/text()");
            Node xml_refField = xpathAPI.selectSingleNode(xml_ddbeanRef, "ref-field/text()");
            Node xml_refFindXpath = xpathAPI.selectSingleNode(xml_ddbeanRef, "ref-find-xpath/text()");
            String refXpath = xml_refXpath.getNodeValue();
            String refField = xml_refField.getNodeValue();
            String refFindXpath = xml_refFindXpath.getNodeValue();
            Set entries = this._namespaceMap.entrySet();
            for (Map.Entry entry : entries) {
                String prefix = (String)entry.getKey();
                String namespaceURI = (String)entry.getValue();
                refXpath = refXpath.replaceAll(prefix + ":", "'" + namespaceURI + "':");
                refField = refField.replaceAll(prefix + ":", "'" + namespaceURI + "':");
                refFindXpath = refFindXpath.replaceAll(prefix + ":", "'" + namespaceURI + "':");
            }
            ddbeanRefs.add(new DDBeanReference(xml_srcXpath.getNodeValue(), refFindXpath, refXpath, refField));
            if (xml_key == null) continue;
            this._references.setProperty(xml_key.getNodeValue(), parentXpath + "/" + refXpath + "/" + refField + "[text()='${" + xml_srcXpath.getNodeValue() + "}']");
        }
        spec.setDDBeanReferences(ddbeanRefs.toArray(new DDBeanReference[ddbeanRefs.size()]));
        NodeList children = xpathAPI.selectNodeList(xml_bean, "child-dconfigbean/text()");
        if (children != null) {
            ArrayList<DConfigBeanSpecification> dconfigbeans = new ArrayList<DConfigBeanSpecification>();
            DDBeanReference ref = (DDBeanReference)ddbeanRefs.get(0);
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                DConfigBeanSpecification childSpec = this.parseChild(xpathAPI, document, child.getNodeValue(), parentXpath + "/" + ref.getRefFindXPath());
                if (childSpec == null) continue;
                dconfigbeans.add(childSpec);
            }
            spec.setChildren(dconfigbeans.toArray(new DConfigBeanSpecification[dconfigbeans.size()]));
        }
        return spec;
    }

    private void parseNamespace(IXPathAPI xpathAPI, Document document) throws Exception {
        NodeList namespaces = xpathAPI.selectNodeList(document, "/dconfigbeans/namespace");
        for (int i = 0; i < namespaces.getLength(); ++i) {
            Node namespace = namespaces.item(i);
            Node uri = xpathAPI.selectSingleNode(namespace, "./uri/text()");
            Node prefix = xpathAPI.selectSingleNode(namespace, "./prefix/text()");
            if (uri == null || prefix == null) continue;
            this._namespaceMap.put(prefix.getNodeValue(), uri.getNodeValue());
        }
    }

    static {
        moduleTypeMap.put("EAR", ModuleType.EAR);
        moduleTypeMap.put("EJB", ModuleType.EJB);
        moduleTypeMap.put("WAR", ModuleType.WAR);
        moduleTypeMap.put("RAR", ModuleType.RAR);
        moduleTypeMap.put("CAR", ModuleType.CAR);
    }
}

