/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import jeus.deploy.io.DeploymentDescriptorFile;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;

public class ConnectorDeploymentDescriptorFile
extends DeploymentDescriptorFile {
    public static final String xsdFileName = "connector_1_5.xsd";

    protected String getSchemaFileName() {
        return xsdFileName;
    }

    public ConnectorDeploymentDescriptorFile() {
        super("jeus.xml.binding.j2ee", "META-INF", "ra.xml");
    }

    public InputStream getSchemaBasedStream(InputStream isInitial) throws IOException {
        byte[] buffer = new byte[4096];
        PushbackInputStream is = new PushbackInputStream(ConnectorDeploymentDescriptorFile.getUnicodeInputStream(isInitial), 4096);
        int num = is.read(buffer);
        String content = new String(buffer, 0, num);
        int index = content.indexOf("<connector>");
        if (index >= 0) {
            XMLTree tree;
            is.unread(buffer, 0, num);
            XMLUtil util = new XMLUtil();
            try {
                tree = util.process((InputStream)is, false, 2382);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            XMLTree spec = tree.getFirstElement("spec-version");
            tree.removeElement(spec);
            XMLTree version = tree.getFirstElement("version");
            if (version != null) {
                tree.removeElement(version);
                XMLTree subTree = new XMLTree("resourceadapter-version", "");
                subTree.setValue(version.getValue());
                Vector v = tree.getElements();
                int idx = v.indexOf(tree.getFirstElement("resourceadapter"));
                if (idx < 0) {
                    idx = v.size();
                }
                v.add(idx, subTree);
            }
            tree.addAttribute("xmlns", "http://java.sun.com/xml/ns/j2ee");
            tree.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            tree.addAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee connector_1_5.xsd");
            tree.addAttribute("version", "1.5");
            ArrayList<String> conDefs = new ArrayList<String>();
            conDefs.add("managedconnectionfactory-class");
            conDefs.add("connectionfactory-interface");
            conDefs.add("connectionfactory-impl-class");
            conDefs.add("connection-interface");
            conDefs.add("connection-impl-class");
            conDefs.add("config-property");
            ArrayList<String> etcs = new ArrayList<String>();
            etcs.add("authentication-mechanism");
            etcs.add("transaction-support");
            etcs.add("reauthentication-support");
            Enumeration enum1 = tree.getElement("resourceadapter").elements();
            while (enum1.hasMoreElements()) {
                XMLTree ra = (XMLTree)enum1.nextElement();
                XMLTree outBound = this.getSubtree(ra, "outbound-resourceadapter", "");
                XMLTree conDef = this.getSubtree(outBound, "connection-definition", "");
                this.moveElements(ra, outBound, etcs);
                this.moveElements(ra, conDef, conDefs);
            }
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            try {
                util.generate(tree);
                util.write(bao);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            System.out.println("" + new String(bao.toByteArray()));
            is.close();
            return new ByteArrayInputStream(bao.toByteArray());
        }
        is.unread(buffer, 0, num);
        return is;
    }

    private void moveElements(XMLTree from, XMLTree to, ArrayList keys) {
        ArrayList<XMLTree> list = new ArrayList<XMLTree>();
        for (XMLTree temp : from.getElements()) {
            if (!keys.contains(temp.getName())) continue;
            to.addElement(temp);
            list.add(temp);
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            from.removeElement(list.get(i));
        }
        list = null;
    }

    private XMLTree getSubtree(XMLTree xmlTree, String name, String value) {
        XMLTree subTree = new XMLTree(name, value);
        xmlTree.addElement(subTree);
        return subTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String fileName = args.length == 0 ? "c:/temp2.xml" : args[0];
        ConnectorDeploymentDescriptorFile desc = new ConnectorDeploymentDescriptorFile();
        InputStream is = null;
        try {
            is = desc.getSchemaBasedStream(new FileInputStream(fileName));
        }
        catch (IOException ioe) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

