/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.service.descriptor.DescriptorFile;

public abstract class DeploymentDescriptorFile
extends DescriptorFile {
    protected String descriptorVersion;
    protected String schemaLocation;
    private String rootElement;
    public static final int DESCRIPTOR_HEADER_SIZE = 4096;
    protected String dtdUrl;

    protected DeploymentDescriptorFile(String contextPackageName, String descriptorDirectory, String descriptorFileName) {
        this(contextPackageName, descriptorDirectory, descriptorFileName, null, null, null);
    }

    protected DeploymentDescriptorFile(String contextPackageName, String descriptorDirectory, String descriptorFileName, String descriptorVersion, String schemaLocation, String rootElement) {
        super(contextPackageName, descriptorDirectory, descriptorFileName);
        this.descriptorVersion = descriptorVersion;
        this.schemaLocation = schemaLocation;
        this.rootElement = rootElement;
    }

    public InputStream getSchemaBasedStream(InputStream is) throws IOException {
        if (this.rootElement != null) {
            return this.getSchemaBasedStream(is, this.rootElement, this.descriptorVersion, this.schemaLocation);
        }
        return is;
    }

    public InputStream getSchemaBasedStream(InputStream isInitial, String _rootElement, String _dtdVersion, String _schemaLocation) throws IOException {
        InputStream returnStream;
        PushbackInputStream is = new PushbackInputStream(DeploymentDescriptorFile.getUnicodeInputStream(isInitial), 4096);
        byte[] buffer = new byte[4096];
        int num = is.read(buffer);
        String content = new String(buffer, 0, num);
        int index = content.indexOf(_rootElement);
        int lastIndex = index + _rootElement.length();
        int docTypeIndex2 = content.indexOf("<!DOCTYPE");
        if (index >= 0 && docTypeIndex2 >= 0) {
            int docTypeIndex3 = content.indexOf(62, docTypeIndex2);
            this.dtdUrl = content.substring(docTypeIndex2, docTypeIndex3);
            int quote = 39;
            int endIndex = this.dtdUrl.lastIndexOf(39);
            if (endIndex < 0) {
                quote = 34;
                endIndex = this.dtdUrl.lastIndexOf(34);
            }
            this.dtdUrl = this.dtdUrl.substring(0, endIndex);
            this.dtdUrl = this.dtdUrl.substring(this.dtdUrl.lastIndexOf(quote) + 1, this.dtdUrl.length());
            StringBuffer prev = new StringBuffer(content.substring(0, docTypeIndex2));
            prev.append(content.substring(index, lastIndex));
            prev.append(" version=\"" + _dtdVersion + "\"").append(" xmlns=\"http://java.sun.com/xml/ns/javaee\"").append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee " + _schemaLocation + "\"").append(DeploymentDescriptorFile.correctifyContent(content.substring(lastIndex)));
            buffer = new byte[2048];
            num = is.read(buffer);
            while (num >= 0) {
                prev.append(new String(buffer, 0, num));
                num = is.read(buffer);
            }
            is.close();
            String stringToWrite = DeploymentDescriptorFile.correctifyContent(prev.toString());
            returnStream = new ByteArrayInputStream(stringToWrite.getBytes());
        } else {
            is.unread(buffer, 0, num);
            returnStream = is;
        }
        return returnStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCorrespondingArchive(AbstractArchive archive) throws IOException {
        InputStream is = null;
        try {
            is = this.getDescriptorStream(archive);
            if (is != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
        }
    }

    public String setAltDD(InputStream altDDStream, JarOutputStream out) throws IOException {
        String descriptorPath = this.getDeploymentDescriptorPath();
        ArchiveHelper.copy((InputStream)altDDStream, (String)descriptorPath, (ZipOutputStream)out);
        return descriptorPath;
    }

    protected static String correctifyContent(String s) {
        s = s.replaceAll(">\\p{Space}*False\\p{Space}*<", ">false<");
        s = s.replaceAll(">\\p{Space}*True\\p{Space}*<", ">true<");
        return s;
    }
}

