/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.io;

import java.util.List;
import javax.xml.bind.JAXBException;
import jeus.deploy.io.DeploymentDescriptorFile;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;
import jeus.xml.binding.j2ee.CmpVersionType;
import jeus.xml.binding.j2ee.EjbJarType;
import jeus.xml.binding.j2ee.EnterpriseBeansType;
import jeus.xml.binding.j2ee.EntityBeanType;
import jeus.xml.binding.j2ee.JavaIdentifierType;
import jeus.xml.binding.j2ee.MessageDrivenBeanType;
import jeus.xml.binding.j2ee.ObjectFactory;
import jeus.xml.binding.j2ee.SessionBeanType;

public class EjbDeploymentDescriptorFile
extends DeploymentDescriptorFile {
    public static final String packageName = "jeus.xml.binding.j2ee";
    public static final String xsdFileName = "ejb-jar_3_0.xsd";
    public static final String rootElement = "ejb-jar";
    public static final String descFileName = "ejb-jar.xml";
    public static final String SCHEMA_LOCATION = "http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd";
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb");

    protected String getSchemaFileName() {
        return xsdFileName;
    }

    public void postUnmarshal(Object root) throws JAXBException {
        super.postUnmarshal(root);
        EjbJarType ejbJar = (EjbJarType)root;
        EnterpriseBeansType enterpriseBeansType = ejbJar.getEnterpriseBeans();
        if (enterpriseBeansType != null) {
            List ejbList = enterpriseBeansType.getSessionOrEntityOrMessageDriven();
            for (int i = 0; i < ejbList.size(); ++i) {
                Object obj = ejbList.get(i);
                if (obj instanceof SessionBeanType) {
                    this.validateSessionBeanType((SessionBeanType)obj);
                    continue;
                }
                if (obj instanceof MessageDrivenBeanType) {
                    this.validateMessageDrivenBeanType((MessageDrivenBeanType)obj);
                    continue;
                }
                if (!(obj instanceof EntityBeanType)) continue;
                this.validateEntityBeanType((EntityBeanType)obj, ejbList);
            }
        }
    }

    private void validateSessionBeanType(SessionBeanType sessionBeanType) throws JAXBException {
    }

    private void validateMessageDrivenBeanType(MessageDrivenBeanType messageDrivenBeanType) throws JAXBException {
    }

    private void validateEntityBeanType(EntityBeanType entityBeanType, List ejbList) throws JAXBException {
        CmpVersionType cmpVersion = entityBeanType.getCmpVersion();
        if (this.dtdUrl != null && this.dtdUrl.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd") && cmpVersion == null) {
            cmpVersion = new ObjectFactory().createCmpVersionType();
            cmpVersion.setValue("1.x");
            entityBeanType.setCmpVersion(cmpVersion);
        }
        if (cmpVersion != null && cmpVersion.getValue().equalsIgnoreCase("1.x") && entityBeanType.getQuery() != null && entityBeanType.getQuery().size() > 0) {
            throw new JAXBException("cmp 1.x does not support ejb-query language");
        }
        JavaIdentifierType targetAbstractSchemaName = entityBeanType.getAbstractSchemaName();
        if (cmpVersion != null && cmpVersion.getValue().equalsIgnoreCase("2.x")) {
            if (targetAbstractSchemaName == null && entityBeanType.getQuery().size() != 0) {
                throw new JAXBException("<abstract-schema-name> element is not specified for " + entityBeanType.getEjbName().getValue());
            }
            if (targetAbstractSchemaName == null) {
                if (logger.isLoggable(JeusMessage_EJB12._9026_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9026_LEVEL, JeusMessage_EJB12._9026, (Object)entityBeanType.getEjbName().getValue());
                }
            } else {
                for (int i = 0; i < ejbList.size(); ++i) {
                    JavaIdentifierType abstractSchemaName;
                    Object bean = ejbList.get(i);
                    if (!(bean instanceof EntityBeanType) || bean == entityBeanType || (abstractSchemaName = ((EntityBeanType)bean).getAbstractSchemaName()) == null || !abstractSchemaName.getValue().equals(targetAbstractSchemaName.getValue())) continue;
                    throw new JAXBException("<abstract-schema-name> element must be unique in a ejb-jar.xml : " + ((EntityBeanType)bean).getEjbName().getValue() + " and " + entityBeanType.getEjbName().getValue());
                }
            }
        }
    }

    public EjbDeploymentDescriptorFile() {
        super(packageName, "META-INF", descFileName, "2.0", SCHEMA_LOCATION, "<ejb-jar");
    }
}

