/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import jeus.deploy.io.DeploymentDescriptorFile;

public class WebDeploymentDescriptorFile
extends DeploymentDescriptorFile {
    public static final String xsdFileName = "web-app_2_5.xsd";
    private String version = "2.5";

    protected String getSchemaFileName() {
        return xsdFileName;
    }

    public WebDeploymentDescriptorFile() {
        this("WEB-INF");
    }

    public WebDeploymentDescriptorFile(String descriptorDir) {
        super("jeus.xml.binding.j2ee", descriptorDir, "web.xml", "2.3", "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", "<web-app");
    }

    public WebDeploymentDescriptorFile(String descriptorDir, String descriptorFileName) {
        super("jeus.xml.binding.j2ee", descriptorDir, descriptorFileName, "2.3", "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", "<web-app");
    }

    public InputStream getSchemaBasedStream(InputStream isInitial) throws IOException {
        byte[] buffer = new byte[4096];
        PushbackInputStream is = new PushbackInputStream(WebDeploymentDescriptorFile.getUnicodeInputStream(isInitial), 4096);
        int num = is.read(buffer);
        String content = new String(buffer, 0, num);
        if (content.indexOf("<!DOCTYPE") > -1 && content.indexOf("//DTD Web Application 2.") > -1) {
            this.version = "2.3";
        } else if (content.indexOf("<web-app ") > -1) {
            if (content.indexOf("version=\"2.4\" ") > -1) {
                this.version = "2.4";
            } else if (content.indexOf("version=\"2.5\" ") > -1) {
                this.version = "2.5";
            }
        }
        is.unread(buffer, 0, num);
        return super.getSchemaBasedStream(is);
    }

    public String getServletVersion() {
        return this.version;
    }
}

