/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.deploy.model.JeusDDBeanRoot;
import jeus.deploy.util.ModuleTypeResolver;

public class JeusDeployableObject
implements DeployableObject {
    protected AbstractArchive archive;
    protected AbstractArchive parentArchive;
    protected JeusDDBeanRoot ddBeanRoot;
    protected ModuleType moduleType;
    private URLClassLoader classLoader;

    public JeusDeployableObject(File appFile) throws Exception {
        this(JarArchiveFactory.openArchiveStatic((File)appFile));
    }

    public JeusDeployableObject(AbstractArchive myArch) throws Exception {
        this.archive = myArch;
        this.moduleType = ModuleTypeResolver.getModuleType(myArch);
        this.ddBeanRoot = (JeusDDBeanRoot)this.getDDBeanRoot(ModuleTypeResolver.getEntry(this.moduleType));
    }

    public JeusDeployableObject(AbstractArchive parentArchive, AbstractArchive myArch) throws Exception {
        this(myArch);
        this.parentArchive = parentArchive;
    }

    public ModuleType getType() {
        return this.moduleType;
    }

    public DDBeanRoot getDDBeanRoot() {
        return this.ddBeanRoot;
    }

    public DDBean[] getChildBean(String str) {
        return this.ddBeanRoot.getChildBean(str);
    }

    public String[] getText(String str) {
        return this.ddBeanRoot.getText(str);
    }

    public Class getClassFromScope(String classname) {
        if (this.classLoader == null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(this.archive.getArchiveUrl());
            this.classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        }
        try {
            return this.classLoader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String getModuleDTDVersion() {
        return null;
    }

    public DDBeanRoot getDDBeanRoot(String filename) throws FileNotFoundException, DDBeanCreateException {
        return new JeusDDBeanRoot(this, filename);
    }

    public Enumeration entries() {
        return this.archive.entries();
    }

    public InputStream getEntry(String s) {
        try {
            return this.archive.getEntry(s);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(s);
        }
    }

    public AbstractArchive getArchive() {
        return this.archive;
    }
}

