/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.ejb.MessageDriven;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.deploy.shared.ModuleType;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.InputJarArchive;
import jeus.util.reflect.BytecodeReader;
import jeus.util.reflect.ClassInfo;
import jeus.util.reflect.TypeInfo;

public class ModuleTypeResolver {
    static String EAR_ENTRY = "META-INF/application.xml";
    static String EJB_ENTRY = "META-INF/ejb-jar.xml";
    static String WAR_ENTRY = "WEB-INF/web.xml";
    static String CAR_ENTRY = "META-INF/application-client.xml";
    static String RAR_ENTRY = "META-INF/ra.xml";
    static String JEUS_EJB_ENTRY = "META-INF/jeus-ejb-dd.xml";
    static String JEUS_WAR_ENTRY = "WEB-INF/jeus-web-dd.xml";
    static String JEUS_CAR_ENTRY = "META-INF/jeus-client-dd.xml";
    static String JEUS_RAR_ENTRY = "META-INF/jeus-connector-dd.xml";

    public static ModuleType getModuleType(AbstractArchive archive) throws IOException {
        return ModuleTypeResolver.getModuleType(archive, 0);
    }

    public static ModuleType getModuleType(AbstractArchive archive, int level) throws IOException {
        ModuleType type;
        String uri = archive.getArchiveUri();
        boolean isJarFile = false;
        if (archive instanceof InputJarArchive) {
            if (uri.endsWith(ModuleType.EAR.getModuleExtension())) {
                return ModuleType.EAR;
            }
            if (uri.endsWith(ModuleType.WAR.getModuleExtension())) {
                return ModuleType.WAR;
            }
            if (uri.endsWith(ModuleType.RAR.getModuleExtension())) {
                return ModuleType.RAR;
            }
            isJarFile = true;
        }
        if ((type = ModuleTypeResolver.determineByDescriptor(archive)) != null) {
            return type;
        }
        type = level == 0 ? ModuleTypeResolver.determineByEmbeddedFiles(archive) : ModuleTypeResolver.determineByOneLevelCheckOfEmbeddedFiles(archive);
        if (type != null) {
            return type;
        }
        if (isJarFile && (type = ModuleTypeResolver.determineByInstrospection(archive)) != null) {
            return type;
        }
        return null;
    }

    public static String getEntry(ModuleType moduleType) {
        if (moduleType == ModuleType.EAR) {
            return EAR_ENTRY;
        }
        if (moduleType == ModuleType.EJB) {
            return EJB_ENTRY;
        }
        if (moduleType == ModuleType.WAR) {
            return WAR_ENTRY;
        }
        if (moduleType == ModuleType.RAR) {
            return RAR_ENTRY;
        }
        return CAR_ENTRY;
    }

    public static InputStream getDeploymentDescriptor(AbstractArchive archive) throws IOException {
        ModuleType myType = ModuleTypeResolver.determineByDescriptor(archive);
        if (myType == null) {
            return null;
        }
        try {
            if (myType == ModuleType.EAR) {
                return archive.getEntry(EAR_ENTRY);
            }
            if (myType == ModuleType.EJB) {
                return archive.getEntry(EJB_ENTRY);
            }
            if (myType == ModuleType.WAR) {
                return archive.getEntry(WAR_ENTRY);
            }
            if (myType == ModuleType.CAR) {
                return archive.getEntry(CAR_ENTRY);
            }
            if (myType == ModuleType.RAR) {
                return archive.getEntry(RAR_ENTRY);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static ModuleType determineByDescriptor(AbstractArchive archive) {
        try {
            if (archive.contains(EAR_ENTRY)) {
                return ModuleType.EAR;
            }
            if (archive.contains(EJB_ENTRY) || archive.contains(JEUS_EJB_ENTRY)) {
                return ModuleType.EJB;
            }
            if (archive.contains(WAR_ENTRY) || archive.contains(JEUS_WAR_ENTRY)) {
                return ModuleType.WAR;
            }
            if (archive.contains(RAR_ENTRY) || archive.contains(JEUS_RAR_ENTRY)) {
                return ModuleType.RAR;
            }
            if (archive.contains(CAR_ENTRY) || archive.contains(JEUS_CAR_ENTRY)) {
                return ModuleType.CAR;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleType determineByEmbeddedFiles(AbstractArchive archive) throws IOException {
        Enumeration e = archive.entries();
        while (e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            if (entry.endsWith(".war") || entry.endsWith(".rar")) {
                return ModuleType.EAR;
            }
            if (!entry.endsWith(".jar")) continue;
            AbstractArchive subArchive = archive.getEmbeddedArchive(entry);
            try {
                if (subArchive.contains(EJB_ENTRY)) {
                    ModuleType moduleType = ModuleType.EAR;
                    return moduleType;
                }
                if (!subArchive.contains(CAR_ENTRY)) continue;
                ModuleType moduleType = ModuleType.EAR;
                return moduleType;
            }
            finally {
                subArchive.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleType determineByOneLevelCheckOfEmbeddedFiles(AbstractArchive archive) throws IOException {
        if (!(archive instanceof FileArchive)) {
            return ModuleTypeResolver.determineByEmbeddedFiles(archive);
        }
        File archiveFile = new File(archive.getArchiveUri());
        File[] e = archiveFile.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
        if (e == null) {
            return null;
        }
        int length = e.length;
        for (int i = 0; i < length; ++i) {
            String entry = e[i].getName();
            if (entry.endsWith(".war") || entry.endsWith(".rar")) {
                return ModuleType.EAR;
            }
            if (!entry.endsWith(".jar")) continue;
            AbstractArchive subArchive = archive.getEmbeddedArchive(entry);
            try {
                if (subArchive.contains(EJB_ENTRY)) {
                    ModuleType moduleType = ModuleType.EAR;
                    return moduleType;
                }
                if (!subArchive.contains(CAR_ENTRY)) continue;
                ModuleType moduleType = ModuleType.EAR;
                return moduleType;
            }
            finally {
                subArchive.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleType determineByInstrospection(AbstractArchive archive) {
        try {
            Attributes mainAttrs;
            String mainClass;
            Manifest manifest = archive.getManifest();
            if (manifest != null && (mainClass = (mainAttrs = manifest.getMainAttributes()).getValue(Attributes.Name.MAIN_CLASS)) != null) {
                return ModuleType.CAR;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        BytecodeReader bytecodeReader = BytecodeReader.getInstance();
        TypeInfo statelessType = TypeInfo.getType(Stateless.class);
        TypeInfo statefulType = TypeInfo.getType(Stateful.class);
        TypeInfo mdbType = TypeInfo.getType(MessageDriven.class);
        Enumeration e = archive.entries();
        InputStream is = null;
        while (e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            if (!entry.endsWith(".class")) continue;
            try {
                is = archive.getEntry(entry);
                ClassInfo clsInfo = bytecodeReader.readClass(is);
                if (!clsInfo.isAnnotationPresent(statelessType) && !clsInfo.isAnnotationPresent(statefulType) && !clsInfo.isAnnotationPresent(mdbType)) continue;
                ModuleType moduleType = ModuleType.EJB;
                return moduleType;
            }
            catch (IOException ex) {}
            continue;
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
        return null;
    }
}

