/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.ejb;

import java.io.Serializable;
import java.util.Vector;
import jeus.descriptor.ejb.EJBCSIDescriptor;
import jeus.descriptor.ejb.EJBClusterDescriptor;
import jeus.descriptor.ejb.EJBMessageDrivenDescriptor;
import jeus.util.JeusException;

public class EJBDescriptor
implements Serializable {
    protected String beanName = new String("");
    protected String moduleName = new String("");
    private String ejbBeanClassName = new String("");
    private String ejbObjectClassName = new String("");
    private String ejbLocalObjectClassName = new String("");
    private String ejbObjectImplClassName = new String("");
    private String ejbLocalObjectImplClassName = new String("");
    private String ejbHomeClassName = new String("");
    private String ejbLocalHomeClassName = new String("");
    private String ejbHomeImplClassName = new String("");
    private String ejbLocalHomeImplClassName = new String("");
    private int exportPort = 0;
    private String exportName = new String("");
    private String localExportName = new String("");
    private boolean exportIIOP = false;
    private int connectPoolSize = 0;
    private int connectPoolMax = 100;
    private long connectPoolResizingPeriod = 3600000L;
    private int ejbBeanPoolSize = 0;
    private int ejbBeanPoolMax = 100;
    private long ejbBeanPoolResizingPeriod = 3600000L;
    private int threadPoolSize = 0;
    private int threadPoolStep = 20;
    private int threadPoolMax = 100;
    private long threadPoolResizingPeriod = 3600000L;
    private int capacity = 10000;
    private long passivationTimeout = -1L;
    private long disconnectTimeout = -1L;
    private Vector envs = new Vector(0);
    private Vector ejbRefs = new Vector(0);
    private Vector resourceRefs = new Vector(0);
    private Vector resourceEnvRefs = new Vector(0);
    private Vector roleLinkTable = new Vector(0);
    private String runAsName = new String("");
    private String runAsRole = new String("");
    private boolean isInvocationWithHttp = false;
    private String httpURL = null;
    private int httpPort = 0;
    EJBClusterDescriptor clusterDesc = null;
    private boolean localInvocationOptimized = true;
    private boolean singleVMOnly = false;
    private EJBCSIDescriptor csiDesc = null;
    private String resourceAdapter;

    public void validate() throws JeusException {
        if (this.beanName.equals("")) {
            throw new JeusException(3005);
        }
        if (this.moduleName.equals("")) {
            throw new JeusException(3006);
        }
        if (this.ejbBeanClassName.equals("")) {
            throw new JeusException(3007, (Object[])new String[]{this.moduleName, this.beanName});
        }
        if (!(this instanceof EJBMessageDrivenDescriptor) && (this.ejbObjectClassName.equals("") || this.ejbHomeClassName.equals("")) && (this.ejbLocalObjectClassName.equals("") || this.ejbLocalHomeClassName.equals(""))) {
            throw new JeusException(3008, (Object[])new String[]{this.moduleName, this.beanName});
        }
        if (!this.ejbObjectClassName.equals("") && this.exportName.equals("")) {
            throw new JeusException(3009, (Object[])new String[]{this.moduleName, this.beanName});
        }
        if (this.ejbObjectClassName.equals("") && !this.exportName.equals("")) {
            throw new JeusException(3759, (Object[])new String[]{this.moduleName, this.beanName});
        }
        if (!this.ejbLocalObjectClassName.equals("") && this.localExportName.equals("")) {
            throw new JeusException(3010, (Object[])new String[]{this.moduleName, this.beanName});
        }
        if (this.ejbLocalObjectClassName.equals("") && !this.localExportName.equals("")) {
            throw new JeusException(3760, (Object[])new String[]{this.moduleName, this.beanName});
        }
        if (this.connectPoolSize < 0) {
            throw new JeusException(3011, (Object[])new String[]{this.moduleName, this.beanName, Integer.toString(this.connectPoolSize)});
        }
        if (0 >= this.connectPoolMax || this.connectPoolSize > this.connectPoolMax) {
            throw new JeusException(3012, (Object[])new String[]{this.moduleName, this.beanName, Integer.toString(this.connectPoolMax)});
        }
        if (this.connectPoolResizingPeriod <= 0L) {
            throw new JeusException(3014, (Object[])new String[]{this.moduleName, this.beanName, Long.toString(this.connectPoolResizingPeriod)});
        }
        if (this.ejbBeanPoolSize < 0) {
            throw new JeusException(3015, (Object[])new String[]{this.moduleName, this.beanName, Integer.toString(this.ejbBeanPoolSize)});
        }
        if (0 >= this.ejbBeanPoolMax || this.ejbBeanPoolSize > this.ejbBeanPoolMax) {
            throw new JeusException(3016, (Object[])new String[]{this.moduleName, this.beanName, Integer.toString(this.ejbBeanPoolMax)});
        }
        if (this.ejbBeanPoolResizingPeriod <= 0L) {
            throw new JeusException(3018, (Object[])new String[]{this.moduleName, this.beanName, Long.toString(this.ejbBeanPoolResizingPeriod)});
        }
        if (this.threadPoolSize < 0) {
            throw new JeusException(3019, (Object[])new String[]{this.moduleName, this.beanName, Integer.toString(this.threadPoolSize)});
        }
        if (0 >= this.threadPoolMax || this.threadPoolSize > this.threadPoolMax) {
            throw new JeusException(3020, (Object[])new String[]{this.moduleName, this.beanName, Integer.toString(this.threadPoolMax)});
        }
        if (0 > this.threadPoolStep || this.threadPoolStep > this.threadPoolMax) {
            throw new JeusException(3021, (Object[])new String[]{this.moduleName, this.beanName, Integer.toString(this.threadPoolStep)});
        }
        if (this.threadPoolResizingPeriod <= 0L) {
            throw new JeusException(3022, (Object[])new String[]{this.moduleName, this.beanName, Long.toString(this.threadPoolResizingPeriod)});
        }
        if (this.capacity <= 0) {
            throw new JeusException(3023, (Object[])new String[]{this.moduleName, this.beanName, Integer.toString(this.capacity)});
        }
        if (this.passivationTimeout < -1L) {
            throw new JeusException(3024, (Object[])new String[]{this.moduleName, this.beanName, Long.toString(this.passivationTimeout)});
        }
        if (this.disconnectTimeout < -1L) {
            throw new JeusException(3025, (Object[])new String[]{this.moduleName, this.beanName, Long.toString(this.disconnectTimeout)});
        }
        if (this.clusterDesc != null) {
            this.clusterDesc.validate();
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String s) {
        this.beanName = s;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String s) {
        this.moduleName = s;
    }

    public String getEJBBeanClassName() {
        return this.ejbBeanClassName;
    }

    public void setEJBBeanClassName(String s) {
        this.ejbBeanClassName = s;
    }

    public String getEJBObjectClassName() {
        return this.ejbObjectClassName;
    }

    public void setEJBObjectClassName(String s) {
        this.ejbObjectClassName = s;
    }

    public String getEJBLocalObjectClassName() {
        return this.ejbLocalObjectClassName;
    }

    public void setEJBLocalObjectClassName(String s) {
        this.ejbLocalObjectClassName = s;
    }

    public String getEJBObjectImplClassName() {
        return this.ejbObjectImplClassName;
    }

    public void setEJBObjectImplClassName(String s) {
        this.ejbObjectImplClassName = s;
    }

    public String getEJBLocalObjectImplClassName() {
        return this.ejbLocalObjectImplClassName;
    }

    public void setEJBLocalObjectImplClassName(String s) {
        this.ejbLocalObjectImplClassName = s;
    }

    public String getEJBHomeClassName() {
        return this.ejbHomeClassName;
    }

    public void setEJBHomeClassName(String s) {
        this.ejbHomeClassName = s;
    }

    public String getEJBLocalHomeClassName() {
        return this.ejbLocalHomeClassName;
    }

    public void setEJBLocalHomeClassName(String s) {
        this.ejbLocalHomeClassName = s;
    }

    public String getEJBHomeImplClassName() {
        return this.ejbHomeImplClassName;
    }

    public void setEJBHomeImplClassName(String s) {
        this.ejbHomeImplClassName = s;
    }

    public String getEJBLocalHomeImplClassName() {
        return this.ejbLocalHomeImplClassName;
    }

    public void setEJBLocalHomeImplClassName(String s) {
        this.ejbLocalHomeImplClassName = s;
    }

    public int getExportPort() {
        return this.exportPort;
    }

    public void setExportPort(int port) {
        this.exportPort = port;
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setExportName(String name) {
        this.exportName = name;
    }

    public String getLocalExportName() {
        return this.localExportName;
    }

    public void setLocalExportName(String name) {
        this.localExportName = name;
    }

    public boolean getExportIIOP() {
        return this.exportIIOP;
    }

    public void setExportIIOP(boolean b) {
        this.exportIIOP = b;
    }

    public int getConnectPoolSize() {
        return this.connectPoolSize;
    }

    public void setConnectPoolSize(int size) {
        this.connectPoolSize = size;
    }

    public int getConnectPoolMax() {
        return this.connectPoolMax;
    }

    public void setConnectPoolMax(int size) {
        this.connectPoolMax = size;
    }

    public long getConnectPoolResizingPeriod() {
        return this.connectPoolResizingPeriod;
    }

    public void setConnectPoolResizingPeriod(long l) {
        this.connectPoolResizingPeriod = l;
    }

    public int getEJBBeanPoolSize() {
        return this.ejbBeanPoolSize;
    }

    public void setEJBBeanPoolSize(int size) {
        this.ejbBeanPoolSize = size;
    }

    public int getEJBBeanPoolMax() {
        return this.ejbBeanPoolMax;
    }

    public void setEJBBeanPoolMax(int size) {
        this.ejbBeanPoolMax = size;
    }

    public long getEJBBeanPoolResizingPeriod() {
        return this.ejbBeanPoolResizingPeriod;
    }

    public void setEJBBeanPoolResizingPeriod(long l) {
        this.ejbBeanPoolResizingPeriod = l;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int size) {
        this.threadPoolSize = size;
    }

    public int getThreadPoolStep() {
        return this.threadPoolStep;
    }

    public void setThreadPoolStep(int size) {
        this.threadPoolStep = size;
    }

    public int getThreadPoolMax() {
        return this.threadPoolMax;
    }

    public void setThreadPoolMax(int size) {
        this.threadPoolMax = size;
    }

    public long getThreadPoolResizingPeriod() {
        return this.threadPoolResizingPeriod;
    }

    public void setThreadPoolResizingPeriod(long l) {
        this.threadPoolResizingPeriod = l;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int i) {
        this.capacity = i;
    }

    public long getPassivationTimeout() {
        return this.passivationTimeout;
    }

    public void setPassivationTimeout(long t) {
        this.passivationTimeout = t;
    }

    public long getDisconnectTimeout() {
        return this.disconnectTimeout;
    }

    public void setDisconnectTimeout(long t) {
        this.disconnectTimeout = t;
    }

    public Vector getEnvs() {
        return this.envs;
    }

    public void setEnvs(Vector v) {
        this.envs = v;
    }

    public Vector getEJBRefs() {
        return this.ejbRefs;
    }

    public void setEJBRefs(Vector v) {
        this.ejbRefs = v;
    }

    public Vector getResourceRefs() {
        return this.resourceRefs;
    }

    public void setResourceRefs(Vector v) {
        this.resourceRefs = v;
    }

    public Vector getResourceEnvRefs() {
        return this.resourceEnvRefs;
    }

    public void setResourceEnvRefs(Vector v) {
        this.resourceEnvRefs = v;
    }

    public Vector getRoleLinkTable() {
        return this.roleLinkTable;
    }

    public void setRoleLinkTable(Vector v) {
        this.roleLinkTable = v;
    }

    public String getRunAsName() {
        return this.runAsName;
    }

    public void setRunAsName(String s) {
        this.runAsName = s;
    }

    public String getRunAsRole() {
        return this.runAsRole;
    }

    public void setRunAsRole(String s) {
        this.runAsRole = s;
    }

    public EJBClusterDescriptor getClusterDesc() {
        return this.clusterDesc;
    }

    public void setClusterDesc(EJBClusterDescriptor clusterDesc) {
        this.clusterDesc = clusterDesc;
    }

    public boolean isLocalInvocationOptimized() {
        return this.localInvocationOptimized;
    }

    public void setLocalInvocationOptimized(boolean b) {
        this.localInvocationOptimized = b;
    }

    public boolean isSingleVMOnly() {
        return this.singleVMOnly;
    }

    public void setSingleVMOnly(boolean b) {
        this.singleVMOnly = b;
    }

    public EJBCSIDescriptor getEJBCSIDescriptor() {
        return this.csiDesc;
    }

    public void setEJBCSIDescriptor(EJBCSIDescriptor csiDesc) {
        this.csiDesc = csiDesc;
    }

    public void setInvocationWithHttp(boolean b) {
        this.isInvocationWithHttp = b;
    }

    public boolean isInvocationWithHttp() {
        return this.isInvocationWithHttp;
    }

    public void setHttpURL(String url) {
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        this.httpURL = url;
    }

    public String getHttpURL() {
        return this.httpURL;
    }

    public void setHttpPort(int i) {
        this.httpPort = i;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public String toString() {
        return this.beanName;
    }

    public String getCorrespondResourceAdapter() {
        return this.resourceAdapter;
    }
}

