/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.ejb;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jeus.descriptor.ejb.EJBDescriptor;
import jeus.descriptor.ejb.EJBRelationshipDescriptor;
import jeus.util.JeusException;

public class EJBModDescriptor
implements Serializable {
    private String moduleName = new String("");
    private String clientJarName = new String("");
    private Vector beanList = new Vector(0);
    private Vector roles = new Vector(0);
    private Vector rpTable = new Vector(0);
    private Vector ruTable = new Vector(0);
    private Vector txTable = new Vector(0);
    private Vector relations = new Vector(0);
    private Vector excludeList = new Vector(0);
    private Vector uncheckList = new Vector(0);

    public void validate() throws JeusException {
        if (this.moduleName.equals("")) {
            throw new JeusException(3034);
        }
        Enumeration e = this.beanList.elements();
        while (e.hasMoreElements()) {
            ((EJBDescriptor)e.nextElement()).validate();
        }
        e = this.relations.elements();
        while (e.hasMoreElements()) {
            Vector relation = (Vector)e.nextElement();
            if (relation.size() != 2) {
                throw new JeusException(3582);
            }
            EJBRelationshipDescriptor rdesc1 = (EJBRelationshipDescriptor)relation.elementAt(0);
            EJBRelationshipDescriptor rdesc2 = (EJBRelationshipDescriptor)relation.elementAt(1);
            rdesc1.validate();
            rdesc2.validate();
            if (rdesc1.isCascadeDeletedByOtherBean() && rdesc2.isMany() || rdesc2.isCascadeDeletedByOtherBean() && rdesc1.isMany()) {
                throw new JeusException(3705);
            }
            if (!rdesc1.isMany() && !rdesc2.isMany()) {
                if (rdesc1.fkeyMapColNames.size() <= 0 || rdesc2.fkeyMapColNames.size() <= 0) continue;
                throw new JeusException(3779);
            }
            if ((!rdesc1.isMany() || rdesc2.isMany()) && (rdesc1.isMany() || !rdesc2.isMany()) || (rdesc1.isMany() || rdesc1.fkeyMapColNames.size() <= 0) && (rdesc2.isMany() || rdesc2.fkeyMapColNames.size() <= 0)) continue;
            throw new JeusException(3780);
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String s) {
        this.moduleName = s;
    }

    public String getClientJarName() {
        return this.clientJarName;
    }

    public void setClientJarName(String s) {
        this.clientJarName = s;
    }

    public Vector getBeanList() {
        return this.beanList;
    }

    public void setBeanList(Vector v) {
        this.beanList = v;
    }

    public Vector getRoles() {
        return this.roles;
    }

    public void setRoles(Vector v) {
        this.roles = v;
    }

    public Vector getRPTable() {
        return this.rpTable;
    }

    public void setRPTable(Vector v) {
        this.rpTable = v;
    }

    public Vector getRUTable() {
        return this.ruTable;
    }

    public void setRUTable(Vector v) {
        this.ruTable = v;
    }

    public Vector getTxTable() {
        return this.txTable;
    }

    public void setTxTable(Vector v) {
        this.txTable = v;
    }

    public Vector getRelations() {
        return this.relations;
    }

    public void setRelations(Vector v) {
        this.relations = v;
    }

    public Vector getExcludeList() {
        return this.excludeList;
    }

    public void setExcludeList(Vector v) {
        this.excludeList = v;
    }

    public Vector getUncheckList() {
        return this.uncheckList;
    }

    public void setUncheckList(Vector v) {
        this.uncheckList = v;
    }
}

