/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.jeusserver;

import java.io.Serializable;
import java.util.Vector;
import jeus.util.JeusException;

public class JNDIServerDescriptor
implements Serializable {
    public Vector primarys = new Vector();
    private boolean exportCosNaming = false;
    private int serverBackLogSize = 50;
    private long serverPoolPeriod = 60000L;
    private int serverPoolMin = 5;
    private int serverPoolMax = 10;
    private int localBufferSize = 20480;
    private long localPoolPeriod = 60000L;
    private int localPoolMin = 3;
    private int localPoolMax = 10;
    private int localPoolStep = 1;
    private boolean isNonBlocking = true;

    public void validate() throws JeusException {
        if (this.serverPoolPeriod <= 0L) {
            throw new JeusException("invalid Naming Server Service Pool Period : " + this.serverPoolPeriod);
        }
        if (this.serverPoolMin < 0) {
            throw new JeusException("invalid Naming Server Service Pool Min : " + this.serverPoolMin);
        }
        if (0 >= this.serverPoolMax || this.serverPoolMin > this.serverPoolMax) {
            throw new JeusException("invalid Naming Server Service Pool Max : " + this.serverPoolMax);
        }
        if (this.localPoolPeriod <= 0L) {
            throw new JeusException("invalid Naming Server Manage Pool Period : " + this.localPoolPeriod);
        }
        if (this.localPoolMin < 0) {
            throw new JeusException("invalid Naming Server Manage Pool Min : " + this.localPoolMin);
        }
        if (0 >= this.localPoolMax || this.localPoolMin > this.localPoolMax) {
            throw new JeusException("invalid Naming Server Manage Pool Max : " + this.localPoolMax);
        }
        if (0 > this.localPoolStep || this.localPoolStep > this.localPoolMax) {
            throw new JeusException("invalid Naming Server Manage Pool Step : " + this.localPoolStep);
        }
        if (this.serverBackLogSize <= 0) {
            throw new JeusException("invalid Naming Server BackLog Size : " + this.serverBackLogSize);
        }
    }

    public void setExportCosNaming(boolean cos) {
        this.exportCosNaming = cos;
    }

    public boolean getExportCosNaming() {
        return this.exportCosNaming;
    }

    public void setServerBackLogSize(int backlog) {
        this.serverBackLogSize = backlog;
    }

    public int getServerBackLogSize() {
        return this.serverBackLogSize;
    }

    public void setServerPool(int min, int max, int step, long period) {
        this.serverPoolMin = min;
        this.serverPoolMax = max;
        this.serverPoolPeriod = period;
    }

    public long getServerPoolPeriod() {
        return this.serverPoolPeriod;
    }

    public int getServerPoolMin() {
        return this.serverPoolMin;
    }

    public int getServerPoolMax() {
        return this.serverPoolMax;
    }

    public void setLocalPool(int min, int max, int step, long period) {
        this.localPoolMin = min;
        this.localPoolMax = max;
        this.localPoolStep = step;
        this.localPoolPeriod = period;
    }

    public long getLocalPoolPeriod() {
        return this.localPoolPeriod;
    }

    public int getLocalPoolMin() {
        return this.localPoolMin;
    }

    public int getLocalPoolMax() {
        return this.localPoolMax;
    }

    public int getLocalPoolStep() {
        return this.localPoolStep;
    }

    public void setNonBlocking(boolean flag) {
        this.isNonBlocking = flag;
    }

    public boolean isNonBlocking() {
        return this.isNonBlocking;
    }
}

