/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.jms;

import java.io.Serializable;
import java.util.ArrayList;
import jeus.descriptor.jms.ClientDescriptor;
import jeus.descriptor.jms.DurableSubscriberDescriptor;
import jeus.descriptor.jms.JMSDescriptorClass;
import jeus.xml.binding.jeusDD.DestinationType;

public class DestinationDescriptor
implements Serializable,
JMSDescriptorClass {
    public static final int DEFAULT_TYPE = 1;
    public int type = 1;
    public String name;
    public String JNDIname;
    public int numberOfMessages;
    public ArrayList receiverAddress;
    public ArrayList durableSubscribers;
    public boolean isSyncReceive;
    public int maxBytes = -1;
    public ArrayList asyncRelayDestinations = new ArrayList();
    private int thresholdNumberForFlowControl = 3000;
    private boolean permitMultipleReceiver = false;
    private int prefetchNumber = 30;
    private String brokerName;

    public DestinationDescriptor() {
    }

    public DestinationDescriptor(DestinationType d) {
        String _type = d.getType().value();
        if (_type.equalsIgnoreCase("queue")) {
            this.type = 1;
        } else if (_type.equalsIgnoreCase("topic")) {
            this.type = 2;
        }
        this.name = d.getName();
        String _exportName = d.getExportName();
        this.JNDIname = _exportName != null ? _exportName : this.name;
        this.permitMultipleReceiver = d.isMultipleReceiver();
        this.brokerName = d.getBrokerName();
    }

    public int getThresholdNumberForFlowControl() {
        return this.thresholdNumberForFlowControl;
    }

    public int getPrefetchNumber() {
        return this.prefetchNumber;
    }

    public boolean isPermitMultipleReceiver() {
        return this.permitMultipleReceiver;
    }

    public void initArrayList() {
        this.receiverAddress = new ArrayList();
        this.durableSubscribers = new ArrayList();
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setMaxBytes(int _maxBytes) {
        this.maxBytes = _maxBytes;
    }

    public int getMaxBytes() {
        return this.maxBytes;
    }

    public void setName(String name) {
        this.name = name;
        this.JNDIname = name;
    }

    public String getName() {
        return this.name;
    }

    public void setJNDIName(String name) {
        this.JNDIname = name;
    }

    public String getJNDIName() {
        return this.JNDIname;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DestinationDescriptor) {
            return this.name.equals(((DestinationDescriptor)obj).name);
        }
        return false;
    }

    public void setMessageNumber(int number) {
        this.numberOfMessages = number;
    }

    public int getMessageNumber() {
        return this.numberOfMessages;
    }

    public void addReceiverDescriptor(ClientDescriptor client) {
        this.receiverAddress.add(client);
    }

    public int getReceiverAddressSize() {
        return this.receiverAddress.size();
    }

    public ClientDescriptor getReceiverAddress(int index) {
        return (ClientDescriptor)this.receiverAddress.get(index);
    }

    public void addDurableDescriptor(DurableSubscriberDescriptor durable) {
        this.durableSubscribers.add(durable);
    }

    public int getDurableSubscriberSize() {
        return this.durableSubscribers.size();
    }

    public DurableSubscriberDescriptor getDurableSubscriber(int index) {
        return (DurableSubscriberDescriptor)this.durableSubscribers.get(index);
    }

    public void setSyncReceive(boolean isSyncReceive) {
        this.isSyncReceive = isSyncReceive;
    }

    public boolean isSyncReceive() {
        return this.isSyncReceive;
    }

    public ArrayList getDurableSubscribers() {
        return this.durableSubscribers;
    }

    public ArrayList getReceiverAddresses() {
        return this.receiverAddress;
    }

    public ArrayList getAsyncRelayDestinations() {
        return this.asyncRelayDestinations;
    }

    public void setAsyncRelayDestinations(ArrayList asyncRelayDestinations) {
        this.asyncRelayDestinations = asyncRelayDestinations;
    }
}

