/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.InstanceAlreadyExistsException;
import jeus.deploy.archivist.AbstractArchive;
import jeus.descriptor.sessionmanager.DistributedSessionManagerDescriptor;
import jeus.ejb.BeanContainer;
import jeus.ejb.EJB3Module;
import jeus.ejb.EJBContainer;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.EJBLoggers;
import jeus.ejb.EJBServerUtils;
import jeus.ejb.container.AbstractContainer;
import jeus.ejb.container.TimerContainer;
import jeus.ejb.ejbserver.ActiveManager;
import jeus.ejb.ejbserver.EJBORBManager;
import jeus.ejb.ejbserver.EJBServerException;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.ejb.EJBEngineMo;
import jeus.security.util.LoginUtil;
import jeus.server.ConfigFile;
import jeus.server.enginecontainer.EngineContainer;
import jeus.service.descriptor.EJBMainDescriptorFile;
import jeus.util.JeusPort;
import jeus.util.JeusRuntimeException;
import jeus.util.Runner;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.message.JeusMessage_EJB8;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.xml.binding.jeusDD.EjbEngineType;

public class EJBEngine
implements EJBContainer {
    private static JeusLogger logger = EJBLoggers.getLogger("jeus.ejb.engine");
    private static final String fs = File.separator;
    private static volatile EJBEngine server;
    private static final long DEFAULT_PASSIVATION_TO = 300000L;
    private static boolean lightVersion;
    private static final AtomicReference<Status> status;
    protected final ConcurrentHashMap<String, EJB3Module> modules = new ConcurrentHashMap();
    protected final List<String> deploying = new Vector<String>();
    protected String engineName;
    protected Timer timer;
    protected long resolution;
    private TimerContainer timerContainer;
    private EjbEngineType desc;
    private DistributedSessionManagerDescriptor sessionManagerDescriptor;
    private ActiveManager activeManager;
    private boolean isUserLoggingOn = false;
    private J2EEManagedObject engineMo;

    public static EJBEngine getDefaultEngine() {
        return server;
    }

    private static void setDefaultEngine(EJBEngine engine) {
        server = engine;
    }

    public static boolean isLightVersion() {
        return lightVersion;
    }

    public EJBEngine() {
        server = this;
    }

    private EJBEngine(String _engineName) throws EJBServerException {
        if (_engineName == null) {
            throw new NullPointerException("engine name is null");
        }
        this.engineName = _engineName;
        try {
            EJBMainDescriptorFile descFile = new EJBMainDescriptorFile(this.getName(), new ConfigFile());
            this.desc = (EjbEngineType)descFile.getDeploymentDescriptor((AbstractArchive)JeusManagerPropertyValues.getConfigArchive());
            this.resolution = this.desc.getResolution();
            System.setProperty("jeus.ejb.codebase", "jeuscftp://" + EJBServerUtils.getJndiUrl() + ":" + JeusPort.ClassFTP + "/JeusEJBApp/");
            this.isUserLoggingOn = this.desc.isEnableUserNotify();
            this.sessionManagerDescriptor = lightVersion ? DistributedSessionManagerDescriptor.getJeusDefaultManagerConfig(_engineName, true, 300000L) : DistributedSessionManagerDescriptor.getJeusManagerConfig(_engineName, true, 300000L);
            this.sessionManagerDescriptor.setStopWithPassivation(false);
        }
        catch (Throwable exc) {
            throw new EJBServerException(JeusMessage_EJB8._5066, exc);
        }
        if (logger.isLoggable(JeusMessage_EJB8._5067_LEVEL)) {
            logger.logp(JeusMessage_EJB8._5067_LEVEL, "EJBServer", "initEnvironment", JeusMessage_EJB8._5067);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initialize() throws EJBServerException {
        activeManagementType = this.desc.getActiveManagement();
        emailDesc = activeManagementType.getEmailNotify();
        try {
            this.activeManager = new ActiveManager(activeManagementType.getMaxBlockedThread(), activeManagementType.getMaxIdleTime(), this.resolution, emailDesc);
            this.activeManager.start();
            if (EJBEngine.logger.isLoggable(JeusMessage_EJB8._5054_LEVEL)) {
                EJBEngine.logger.logp(JeusMessage_EJB8._5054_LEVEL, "EJBServer", "<init>", JeusMessage_EJB8._5054);
            }
        }
        catch (Throwable t) {
            if (EJBEngine.logger.isLoggable(JeusMessage_EJB8._5055_LEVEL)) {
                EJBEngine.logger.logp(JeusMessage_EJB8._5055_LEVEL, "EJBServer", "<init>", JeusMessage_EJB8._5055, t);
            }
            throw new EJBServerException(JeusMessage_EJB8._5055, t);
        }
        if (this.resolution > 0L) {
            try {
                this.timer = new Timer("EJBEngineTimer_" + this.getName(), true);
                this.timer.schedule((TimerTask)new PassivationTimerTask(), this.resolution, this.resolution);
                if (!EJBEngine.logger.isLoggable(JeusMessage_EJB8._5060_LEVEL)) ** GOTO lbl26
                EJBEngine.logger.logp(JeusMessage_EJB8._5060_LEVEL, "EJBServer", "<init>", JeusMessage_EJB8._5060);
            }
            catch (Throwable ex) {
                if (EJBEngine.logger.isLoggable(JeusMessage_EJB8._5061_LEVEL)) {
                    EJBEngine.logger.logp(JeusMessage_EJB8._5061_LEVEL, "EJBServer", "<init>", JeusMessage_EJB8._5061, ex);
                }
                throw new EJBServerException(JeusMessage_EJB8._5061, ex);
            }
        } else if (EJBEngine.logger.isLoggable(JeusMessage_EJB12._9001_LEVEL)) {
            EJBEngine.logger.log(JeusMessage_EJB12._9001_LEVEL, JeusMessage_EJB12._9001);
        }
lbl26:
        // 5 sources

        if (EJBEngine.logger.isLoggable(JeusMessage_EJB8._5199_LEVEL)) {
            EJBEngine.logger.logp(JeusMessage_EJB8._5199_LEVEL, "EJBServer", "initTimerContainer", JeusMessage_EJB8._5199);
        }
        this.timerContainer = new TimerContainer();
        this.timerContainer.init(this.desc.getTimerService());
        if (EJBEngine.logger.isLoggable(JeusMessage_EJB8._5200_LEVEL)) {
            EJBEngine.logger.logp(JeusMessage_EJB8._5200_LEVEL, "EJBServer", "initTimerContainer", JeusMessage_EJB8._5200);
        }
        try {
            this.engineMo = EJBEngineMo.createMBean(this.engineName, EngineContainer.serverMBean.getObjectName(), EJBEngine.server);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new EJBServerException("Could not create EJB Engine MBean", (Throwable)e);
        }
    }

    public EjbEngineType getEjbEngineDescriptor() {
        return this.desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeployingModule(EJB3Module module) throws EJBDeploymentException {
        String moduleName = module.getModuleName();
        ConcurrentHashMap<String, EJB3Module> concurrentHashMap = this.modules;
        synchronized (concurrentHashMap) {
            if (this.modules.get(moduleName) != null) {
                throw new EJBDeploymentException("EJB module " + moduleName + " is already deployed.");
            }
            if (this.deploying.contains(moduleName)) {
                throw new EJBDeploymentException("The deployment of EJB module " + moduleName + " is in progress");
            }
            this.deploying.add(moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeployingModule(EJB3Module module) {
        String moduleName = module.getModuleName();
        ConcurrentHashMap<String, EJB3Module> concurrentHashMap = this.modules;
        synchronized (concurrentHashMap) {
            this.deploying.remove(moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeployedModule(EJB3Module module) {
        ConcurrentHashMap<String, EJB3Module> concurrentHashMap = this.modules;
        synchronized (concurrentHashMap) {
            this.modules.put(module.getModuleName(), module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeployedModule(EJB3Module module) {
        ConcurrentHashMap<String, EJB3Module> concurrentHashMap = this.modules;
        synchronized (concurrentHashMap) {
            this.modules.remove(module.getModuleName());
        }
    }

    public static BeanContainer getContainer(String moduleName, String beanName) {
        EJBEngine engine = EJBEngine.getDefaultEngine();
        if (engine == null) {
            throw new IllegalStateException("EJB Engine is not available");
        }
        EJB3Module module = engine.modules.get(moduleName);
        if (module == null) {
            if (logger.isLoggable(JeusMessage_EJB8._5077_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5077_LEVEL, "EJBServer", "getContainer", JeusMessage_EJB8._5077, (Object)moduleName);
            }
            return null;
        }
        return module.getContainerList().get(beanName);
    }

    public static BeanContainer getContainer(String ejbId) {
        String[] names = AbstractContainer.getModuleNameAndBeanNameFromEJBId(ejbId);
        BeanContainer container = EJBEngine.getContainer(names[0], names[1]);
        return container;
    }

    public static void main(String[] args) {
        if (!Runner.checkLicenseEdition(Runner.LIC_EDITION_STANDARD)) {
            throw new JeusRuntimeException(JeusMessage_EJB8._5195);
        }
        int edition = Runner.getLicenseEdition();
        if (edition != Runner.LIC_EDITION_BASEPLUS && edition != Runner.LIC_EDITION_ENTERPRISE) {
            lightVersion = true;
        }
        EJBEngine.startEngine(args[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void down() {
        Status currentStatus = status.get();
        if (currentStatus == Status.DOWN) {
            return;
        }
        String engineName = "";
        if (server != null) {
            engineName = server.getName();
        }
        if (logger.isLoggable(JeusMessage_EJB8._5177_LEVEL)) {
            logger.logp(JeusMessage_EJB8._5177_LEVEL, "EJBServer", "down", JeusMessage_EJB8._5177, (Object)engineName);
        }
        try {
            status.set(Status.STOPPING);
            LoginUtil.loginCodeSubjectWithRuntimeException();
            try {
                try {
                    EngineContainer.undeployApp("EJBModule");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    EJBORBManager.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (server != null) {
                    try {
                        if (EJBEngine.server.activeManager != null) {
                            EJBEngine.server.activeManager.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        if (EJBEngine.server.timer != null) {
                            EJBEngine.server.timer.cancel();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        if (EJBEngine.server.engineMo != null) {
                            EJBEngine.server.engineMo.destroyMBean();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        if (EJBEngine.server.timerContainer != null) {
                            EJBEngine.server.timerContainer.down();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    server = null;
                }
                if (logger.isLoggable(JeusMessage_EJB8._5183_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5183_LEVEL, "EJBServer", "down", JeusMessage_EJB8._5183, (Object)engineName);
                }
                logger.flush();
            }
            finally {
                LoginUtil.logoutWithRuntimeException();
            }
        }
        finally {
            status.set(Status.DOWN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startEngine(String engineName) throws JeusRuntimeException {
        Status currentStatus = status.get();
        if (currentStatus != Status.DOWN) {
            throw new JeusRuntimeException("Could not start EJB Engine: current status=" + currentStatus.name());
        }
        boolean success = false;
        try {
            if (!status.compareAndSet(Status.DOWN, Status.STARTING)) {
                return;
            }
            LoginUtil.loginCodeSubjectWithRuntimeException();
            try {
                if (logger.isLoggable(JeusMessage_EJB8._5196_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5196_LEVEL, "EJBServer", "main", JeusMessage_EJB8._5196, (Object)engineName);
                }
                server = new EJBEngine(engineName);
                server.initialize();
            }
            finally {
                LoginUtil.logoutWithRuntimeException();
            }
            success = true;
            if (logger.isLoggable(JeusMessage_EJB8._5197_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5197_LEVEL, "EJBServer", "main", JeusMessage_EJB8._5197, (Object)engineName);
            }
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB8._5198_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5198_LEVEL, "EJBServer", "main", JeusMessage_EJB8._5198, (Object)engineName, ex);
            }
            throw new JeusRuntimeException(JeusMessage_EJB8._5198, (Object)engineName);
        }
        finally {
            if (!success) {
                EJBEngine.down();
            } else {
                status.set(Status.RUNNING);
            }
        }
    }

    public static Status getStatus() {
        return status.get();
    }

    public static boolean isRunning() {
        return status.get() == Status.RUNNING;
    }

    public static boolean isDown() {
        return status.get() == Status.DOWN;
    }

    public String getName() {
        return this.engineName;
    }

    public String getPureEngineName() {
        return this.engineName.substring(this.engineName.lastIndexOf("_") + 1);
    }

    public boolean isUserLoggingOn() {
        return this.isUserLoggingOn;
    }

    public DistributedSessionManagerDescriptor getSessionManagerDescriptor() {
        return this.sessionManagerDescriptor;
    }

    public TimerContainer getTimerContainer() {
        return this.timerContainer;
    }

    public ActiveManager getActiveManager() {
        return this.activeManager;
    }

    static {
        status = new AtomicReference<Status>(Status.DOWN);
    }

    private class PassivationTimerTask
    extends TimerTask {
        private PassivationTimerTask() {
        }

        public void run() {
            block5: {
                if (EJBEngine.isDown()) {
                    return;
                }
                if (logger.isLoggable(JeusMessage_EJB8._5193_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5193_LEVEL, "EJBServer", "<init>", JeusMessage_EJB8._5193);
                }
                try {
                    ArrayList<EJB3Module> list = new ArrayList<EJB3Module>(EJBEngine.this.modules.values());
                    long currentTimeStamp = System.currentTimeMillis();
                    for (EJB3Module module : list) {
                        module.passivate(currentTimeStamp);
                    }
                }
                catch (Throwable ex) {
                    if (!logger.isLoggable(JeusMessage_EJB8._5194_LEVEL)) break block5;
                    logger.logp(JeusMessage_EJB8._5194_LEVEL, "EJBServer", "<init>", JeusMessage_EJB8._5194, ex);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        DOWN,
        STARTING,
        RUNNING,
        STOPPING;

    }
}

