/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.baseimpl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Identity;
import java.security.Principal;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.TimerService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.jacc.EJBRoleRefPermission;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import jeus.ejb.BeanContainer;
import jeus.ejb.BeanContext;
import jeus.ejb.BeanState;
import jeus.ejb.EJBLoggers;
import jeus.ejb.EJBServerUtils;
import jeus.ejb.bean.objectbase.TimerServiceImpl;
import jeus.ejb.io.SerializableWrapper;
import jeus.security.base.SecurityException;
import jeus.security.container.ejb.EJBSecurity;
import jeus.security.util.IdentityImpl;
import jeus.transaction.TxHelper;
import jeus.transaction.UserTransactionImpl;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB0;

public abstract class EJBContextImpl
implements BeanContext,
Serializable {
    protected static final JeusLogger logger = EJBLoggers.logger;
    static final Object[] null_objects = new Object[0];
    protected String ejbName;
    protected transient Object bean;
    protected transient Object[] interceptorInstances;
    protected transient BeanContainer container;
    protected transient UserTransaction usertx;
    protected transient Transaction tx;
    protected transient BeanState state = BeanState.NOT_READY;

    public EJBContextImpl() {
    }

    protected EJBContextImpl(BeanContainer container) {
        this.container = container;
        this.ejbName = container.getBeanName();
    }

    public BeanContainer getContainer() {
        return this.container;
    }

    public void setContainer(BeanContainer con) {
        this.container = con;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object[] getInterceptorInstances() {
        return this.interceptorInstances;
    }

    public void setInterceptorInstances(Object[] interceptorInstances) {
        this.interceptorInstances = interceptorInstances;
    }

    public BeanState getStatus() {
        return this.state;
    }

    public void setStatus(BeanState status) {
        this.state = status;
    }

    public Transaction getTx() {
        return this.tx;
    }

    public void setTx(Transaction tx) {
        this.tx = tx;
    }

    public void reset() {
        this.state = BeanState.NOT_READY;
        this.tx = null;
    }

    public Identity getCallerIdentity() {
        try {
            Principal p = this.container.getRunAsSubject() == null ? EJBSecurity.getEJBCallerPrincipal() : EJBSecurity.getEJBRunasCallerPrincipal();
            if (p == null) {
                throw new JeusRuntimeException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB0._1006));
            }
            return new IdentityImpl(p.getName());
        }
        catch (Throwable ex) {
            throw new JeusRuntimeException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB0._1008) + ex, ex);
        }
    }

    public Principal getCallerPrincipal() {
        this.checkOperationsAllowed(1003);
        try {
            Principal principal = this.container.getRunAsSubject() == null ? EJBSecurity.getEJBCallerPrincipal() : EJBSecurity.getEJBRunasCallerPrincipal();
            return principal;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB0._1011_LEVEL)) {
                logger.logp(JeusMessage_EJB0._1011_LEVEL, "EJBContextImpl", "getCallerPrincipal", JeusMessage_EJB0._1011, ex);
            }
            throw new JeusRuntimeException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB0._1011) + ex, ex);
        }
    }

    public EJBHome getEJBHome() {
        EJBHome home = this.container.getEJBHome();
        if (home == null) {
            if (logger.isLoggable(JeusMessage_EJB0._1013_LEVEL)) {
                logger.logp(JeusMessage_EJB0._1013_LEVEL, "EJBContextImpl", "getEJBHome", JeusMessage_EJB0._1013);
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB0._1013));
        }
        return home;
    }

    public EJBLocalHome getEJBLocalHome() {
        EJBLocalHome localHome = this.container.getEJBLocalHome();
        if (localHome == null) {
            if (logger.isLoggable(JeusMessage_EJB0._1016_LEVEL)) {
                logger.logp(JeusMessage_EJB0._1016_LEVEL, "EJBContextImpl", "getEJBLocalHome", JeusMessage_EJB0._1016);
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB0._1016));
        }
        return localHome;
    }

    public Properties getEnvironment() {
        throw new RuntimeException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB0._1018));
    }

    public final boolean getRollbackOnly() throws IllegalStateException {
        this.checkOperationsAllowed(1007);
        return UserTransactionImpl.getRollbackOnly();
    }

    public final void setRollbackOnly() throws IllegalStateException {
        this.checkOperationsAllowed(1006);
        if (this.usertx == null) {
            this.usertx = TxHelper.getUserTransaction();
        }
        try {
            this.usertx.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB0._1031_LEVEL)) {
                logger.logp(JeusMessage_EJB0._1031_LEVEL, "EJBContextImpl", "setRollbackOnly", JeusMessage_EJB0._1031, ex);
            }
            throw new JeusRuntimeException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB0._1031) + ex, ex);
        }
        if (logger.isLoggable(JeusMessage_EJB0._1032_LEVEL)) {
            logger.logp(JeusMessage_EJB0._1032_LEVEL, "EJBContextImpl", "setRollbackOnly", JeusMessage_EJB0._1032);
        }
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        this.checkOperationsAllowed(1005);
        if (this.usertx == null) {
            if (logger.isLoggable(JeusMessage_EJB0._1022_LEVEL)) {
                logger.logp(JeusMessage_EJB0._1022_LEVEL, "EJBContextImpl", "getUserTransaction", JeusMessage_EJB0._1022);
            }
            this.usertx = EJBServerUtils.getEJBUserTransaction();
        } else if (logger.isLoggable(JeusMessage_EJB0._1023_LEVEL)) {
            logger.logp(JeusMessage_EJB0._1023_LEVEL, "EJBContextImpl", "getUserTransaction", JeusMessage_EJB0._1023);
        }
        return this.usertx;
    }

    public boolean isCallerInRole(Identity identity) {
        return this.isCallerInRole(identity.getName());
    }

    public boolean isCallerInRole(String role) throws IllegalStateException {
        this.checkOperationsAllowed(1004);
        try {
            EJBSecurity.setEJBSecurityContext(this.container.getSecurityPolicyID(), this.bean, null_objects, null);
            if (this.container.getRunAsSubject() == null) {
                EJBSecurity.checkEJBCallerInRole(new EJBRoleRefPermission(this.ejbName, role));
            } else {
                EJBSecurity.checkEJBRunasCallerInRole(new EJBRoleRefPermission(this.ejbName, role));
            }
            if (logger.isLoggable(JeusMessage_EJB0._1027_LEVEL)) {
                logger.logp(JeusMessage_EJB0._1027_LEVEL, "EJBContextImpl", "isCallerInRole", JeusMessage_EJB0._1027, (Object)role);
            }
            boolean bl = true;
            return bl;
        }
        catch (SecurityException ex) {
            if (logger.isLoggable(JeusMessage_EJB0._1028_LEVEL)) {
                logger.logp(JeusMessage_EJB0._1028_LEVEL, "EJBContextImpl", "isCallerInRole", JeusMessage_EJB0._1028, (Object)role);
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB0._1029_LEVEL)) {
                logger.logp(JeusMessage_EJB0._1029_LEVEL, "EJBContextImpl", "isCallerInRole", JeusMessage_EJB0._1029, (Object)role, ex);
            }
            throw new JeusRuntimeException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB0._1029, (Object)role) + ex, ex);
        }
        finally {
            EJBSecurity.clearEJBSecurityContext();
        }
    }

    public TimerService getTimerService() throws IllegalStateException {
        this.checkOperationsAllowed(1008);
        return this.getTimerServiceInternal();
    }

    public TimerService getTimerServiceInternal() {
        return new TimerServiceImpl(this, this.container.getDurableTimerSetting());
    }

    public Object lookup(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("name is empty");
        }
        String jndiName = "java:comp/env/" + name;
        try {
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup(jndiName);
            ctx.close();
            return obj;
        }
        catch (NamingException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    protected String getCheckOperationsAllowedErrorMessage() {
        return "The Operation is not allowed in EJB " + (Object)((Object)this.state) + " state";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerializableWrapper beanWrapper = new SerializableWrapper(this.bean);
        stream.writeObject(beanWrapper);
        if (this.interceptorInstances == null) {
            stream.writeObject(null);
        } else {
            Object[] interceptorWrappers = new Object[this.interceptorInstances.length];
            for (int i = 0; i < interceptorWrappers.length; ++i) {
                interceptorWrappers[i] = new SerializableWrapper(this.interceptorInstances[i]);
            }
            stream.writeObject(interceptorWrappers);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        SerializableWrapper beanWrapper = (SerializableWrapper)stream.readObject();
        this.bean = beanWrapper.getObject();
        Object[] interceptorWrappers = (Object[])stream.readObject();
        if (interceptorWrappers == null) {
            this.interceptorInstances = null;
        } else {
            this.interceptorInstances = new Object[interceptorWrappers.length];
            for (int i = 0; i < interceptorWrappers.length; ++i) {
                this.interceptorInstances[i] = ((SerializableWrapper)interceptorWrappers[i]).getObject();
            }
        }
    }

    public String toString() {
        return "EJBContextImpl:ejbName=" + this.ejbName + ",state=" + (Object)((Object)this.state);
    }
}

