/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.baseimpl;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.util.Arrays;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.RemoveException;
import javax.security.jacc.EJBMethodPermission;
import jeus.ejb.MethodInterfaceType;
import jeus.ejb.baseimpl.EJBObjectBase;
import jeus.ejb.baseimpl.EJBSessionIfObject;
import jeus.ejb.container3.ExceptionMapper;
import jeus.ejb.container3.SessionContainer;
import jeus.ejb.interceptor.InvocationRequest;
import jeus.ejb.interceptor.InvocationType;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.container.ejb.EJBSecurity;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRuntimeException;
import jeus.util.message.JeusMessage_EJB1;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;

public abstract class EJBSessionObjectBase
extends EJBObjectBase
implements EJBSessionIfObject {
    public transient SessionContainer container;
    protected String sessionID;
    protected int hash;

    protected EJBSessionObjectBase() {
    }

    public SessionContainer _getContainer() {
        return this.container;
    }

    public void _setContainer(SessionContainer container) {
        super._setContainer(container);
        this.container = container;
    }

    public String _getSessionID() {
        return this.sessionID;
    }

    public void _setSessionID(String sessionID) {
        this.sessionID = sessionID;
        if (sessionID != null) {
            this.hash = sessionID.hashCode() & Integer.MAX_VALUE;
        }
    }

    public void _activate(SessionContainer container, String sessionID) {
        assert (container != null && sessionID != null);
        this._setContainer(container);
        this.resetIsInvoking();
        this._setSessionID(sessionID);
        this.setIsRemoved(false);
        this.setTransaction(null);
    }

    public void _deactivate() {
        this.setIsRemoved(true);
        this._setSessionID(null);
        this.unexport();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.lang.Object _invoke(InvocationRequest inv) throws Exception {
        this.checkState();
        if (this.isRemoved()) {
            throw new NoSuchObjectException("unexported object");
        }
        inv.setType(InvocationType.BUSINESS_METHOD);
        inv.setCaller(this);
        inv.setMethodInterfaceType(MethodInterfaceType.Remote);
        try {
            return this.container.invoke(inv);
        }
        catch (EJBException ex) {
            throw new RemoteException("Exception from Remote EJB", ex);
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    public java.lang.Object getPrimaryKey() throws RemoteException {
        throw new RemoteException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB1._1906));
    }

    public void remove() throws RemoveException, RemoteException {
        this.checkState();
        try {
            this.container.removeObject(this);
        }
        catch (RemoveException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ExceptionMapper.mapToRemoteException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdentical(EJBObject ejbObj) throws RemoteException {
        this.checkState();
        try {
            EJBSecurity.setEJBSecurityContext(this.container.getSecurityPolicyID(), this.context == null ? null : (this.context == null ? null : this.context.getBean()), new java.lang.Object[]{ejbObj}, null);
        }
        catch (Throwable ex) {
            throw new JeusRuntimeException("Exception occurred", ex);
        }
        try {
            boolean result;
            byte[] id2;
            byte[] id1;
            EJBMethodPermission rsc = this.getIsIdenticalRRsc();
            try {
                EJBSecurity.checkEJBMethodPermission(rsc);
            }
            catch (ServiceException e) {
                throw new JeusRuntimeException("Exception occurred", (Throwable)e);
            }
            catch (SecurityException e) {
                if (logger.isLoggable(JeusMessage_EJB1._1955_LEVEL)) {
                    logger.logp(JeusMessage_EJB1._1955_LEVEL, "EJBStatelessSessionObjectImpl", "isIdentical", JeusMessage_EJB1._1955);
                }
                throw new RemoteException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB1._1955));
            }
            if (ejbObj == this) {
                boolean e = true;
                return e;
            }
            if (ejbObj instanceof RemoteStub) {
                boolean equal2;
                RemoteRef ref = ((RemoteStub)ejbObj).getRef();
                boolean bl = equal2 = ((RemoteStub)this.getRMIStub()).getRef().remoteEquals(ref);
                return bl;
            }
            if (this.container.ejbPOA == null) {
                boolean equal;
                boolean equal2 = equal = ejbObj.equals(this.getIIOPStub());
                return equal2;
            }
            try {
                id1 = ((POA)this.container.ejbPOA).reference_to_id((Object)ejbObj);
                id2 = ((POA)this.container.ejbPOA).reference_to_id((Object)this.getIIOPStub());
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_EJB1._1915_LEVEL)) {
                    logger.logp(JeusMessage_EJB1._1915_LEVEL, "EJBStatefulSessionObjectImpl", "isIdentical", JeusMessage_EJB1._1915, (java.lang.Object)ejbObj);
                }
                boolean bl = false;
                EJBSecurity.clearEJBSecurityContext();
                return bl;
            }
            boolean bl = result = Arrays.equals(id1, id2);
            return bl;
        }
        finally {
            EJBSecurity.clearEJBSecurityContext();
        }
    }
}

