/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.baseimpl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import jeus.ejb.baseimpl.BusinessObjectHandler;
import jeus.ejb.io.IndirectlySerializable;
import jeus.ejb.io.SerializableBusinessObjectHandler;
import jeus.ejb.io.SerializableObjectFactory;
import jeus.ejb.util.InvocationHandlerUtil;

public class LocalBusinessObjectClientHandler
implements InvocationHandler,
IndirectlySerializable {
    private final String ejbId;
    private final String sessionId;
    private final Class interfaze;
    private final BusinessObjectHandler handler;
    private volatile int hashCode = 0;

    public LocalBusinessObjectClientHandler(String ejbId, String sessionId, Class interfaze, BusinessObjectHandler handler) {
        this.ejbId = ejbId;
        this.sessionId = sessionId;
        this.interfaze = interfaze;
        this.handler = handler;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            switch (method.getName().charAt(0)) {
                case 'e': {
                    return this.isIdentical(proxy, args[0]);
                }
                case 'h': {
                    return this.hashCode();
                }
            }
            return InvocationHandlerUtil.invokeJavaObjectMethod(this, method, args);
        }
        try {
            return this.handler.invoke(this.interfaze, method, args);
        }
        catch (Exception ex) {
            if (ex instanceof NoSuchObjectException) {
                throw new NoSuchEJBException(ex.getMessage(), ex);
            }
            if (ex instanceof RemoteException) {
                throw new EJBException(ex.getMessage(), ex);
            }
            throw ex;
        }
    }

    private boolean isIdentical(Object proxy, Object arg) {
        if (proxy == arg) {
            return true;
        }
        if (arg == null || !Proxy.isProxyClass(arg.getClass())) {
            return false;
        }
        InvocationHandler other = Proxy.getInvocationHandler(arg);
        if (!(other instanceof LocalBusinessObjectClientHandler)) {
            return false;
        }
        LocalBusinessObjectClientHandler that = (LocalBusinessObjectClientHandler)other;
        return this.ejbId.equals(that.ejbId) && this.sessionId.equals(that.sessionId) && this.interfaze.equals(that.interfaze);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.ejbId.hashCode();
            this.hashCode = result = 29 * result + this.sessionId.hashCode();
        }
        return this.hashCode;
    }

    public SerializableObjectFactory getSerializableObjectFactory() {
        return new SerializableBusinessObjectHandler(this.ejbId, this.sessionId, this.interfaze.getName());
    }
}

