/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.bean.objectbase;

import java.io.Serializable;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import jeus.ejb.bean.objectbase.TimerHandleImpl;
import jeus.ejb.container.TimerContainer;
import jeus.ejb.io.IndirectlySerializable;
import jeus.ejb.io.SerializableObjectFactory;
import jeus.ejb.io.SerializableTimer;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB2;

public class TimerImpl
implements Timer,
IndirectlySerializable {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.timer");
    protected Long timerId;
    private TimerContainer timerContainer;

    public TimerImpl(Long timerId, TimerContainer timerContainer) {
        if (logger.isLoggable(JeusMessage_EJB2._2351_LEVEL)) {
            logger.logp(JeusMessage_EJB2._2351_LEVEL, "TimerImpl", "<init>", JeusMessage_EJB2._2351, (Object)timerId);
        }
        this.timerId = timerId;
        this.timerContainer = timerContainer;
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        TimerImpl.checkInvokePermission();
        try {
            this.timerContainer.cancelTimer(this.timerId);
        }
        catch (IllegalStateException fe) {
            if (logger.isLoggable(JeusMessage_EJB2._2353_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2353_LEVEL, "TimerImpl", "cancel", JeusMessage_EJB2._2353, (Object)this.timerId, (Throwable)fe);
            }
            throw fe;
        }
        catch (NoSuchObjectLocalException fe) {
            if (logger.isLoggable(JeusMessage_EJB2._2354_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2354_LEVEL, "TimerImpl", "cancel", JeusMessage_EJB2._2354, (Object)this.timerId, (Throwable)fe);
            }
            throw fe;
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_EJB2._2355_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2355_LEVEL, "TimerImpl", "cancel", JeusMessage_EJB2._2355, (Object)this.timerId, (Throwable)e);
            }
            throw new EJBException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2355, (Object)this.timerId), e);
        }
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException {
        Date nextTimeout = this.getNextTimeout();
        Date now = new Date();
        long timeRemaining = nextTimeout.getTime() - now.getTime();
        long remain = timeRemaining <= 0L ? 0L : timeRemaining;
        return remain;
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException {
        Date nextTimeout;
        TimerImpl.checkInvokePermission();
        try {
            nextTimeout = this.timerContainer.getNextTimeout(this.timerId);
        }
        catch (NoSuchObjectLocalException fe) {
            if (logger.isLoggable(JeusMessage_EJB2._2359_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2359_LEVEL, "TimerImpl", "getNextTimeout", JeusMessage_EJB2._2359, (Object)this.timerId, (Throwable)fe);
            }
            throw fe;
        }
        return nextTimeout;
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException {
        Serializable info;
        TimerImpl.checkInvokePermission();
        try {
            info = this.timerContainer.getInfo(this.timerId);
        }
        catch (NoSuchObjectLocalException fe) {
            if (logger.isLoggable(JeusMessage_EJB2._2362_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2362_LEVEL, "TimerImpl", "getInfo", JeusMessage_EJB2._2362, (Object)this.timerId, (Throwable)fe);
            }
            throw fe;
        }
        return info;
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException {
        TimerImpl.checkInvokePermission();
        if (!this.timerContainer.timerExists(this.timerId)) {
            if (logger.isLoggable(JeusMessage_EJB2._2365_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2365_LEVEL, "TimerImpl", "getHandle", JeusMessage_EJB2._2365, (Object)this.timerId);
            }
            throw new NoSuchObjectLocalException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2365, (Object)this.timerId));
        }
        if (logger.isLoggable(JeusMessage_EJB2._2366_LEVEL)) {
            logger.logp(JeusMessage_EJB2._2366_LEVEL, "TimerImpl", "getHandle", JeusMessage_EJB2._2366, (Object)this.timerId);
        }
        return new TimerHandleImpl(this.timerId);
    }

    public SerializableObjectFactory getSerializableObjectFactory() {
        return new SerializableTimer(this.timerId);
    }

    private static void checkInvokePermission() throws IllegalStateException {
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof TimerImpl) {
            TimerImpl other = (TimerImpl)o;
            result = other.timerId.equals(this.timerId);
        }
        return result;
    }
}

